define(["exports","./baseitemcontroller.js","./genericitemcontroller.js","./../globalize.js"],function(_exports,_baseitemcontroller,_genericitemcontroller,_globalize){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var DefaultItemControllerInstance=new _baseitemcontroller.default,commandSources=[],controllersByType={};function getItemController(typeName){return controllersByType[typeName]||DefaultItemControllerInstance}function rejectNoItems(){return Promise.reject("noitems")}function registerItemController(controller){for(var typeNames=controller.getTypeNames(),i=0,length=typeNames.length;i<length;i++)controllersByType[typeNames[i]]=controller}registerItemController(new _genericitemcontroller.default);_exports.default={registerItemController:registerItemController,registerCommandSource:function(commandSource){commandSources.push(commandSource)},getItemController:getItemController,getDisplayName:function(item,options){return getItemController(item.Type).getDisplayName(item,options)},getDefaultIcon:function(item){return getItemController(item.Type).getDefaultIcon(item)},canConvert:function(item,user){return getItemController(item.Type).canConvert(item,user)},canDelete:function(item,user){return getItemController(item.Type).canDelete(item,user)},canEdit:function(item,user){return getItemController(item.Type).canEdit(item,user)},canEditImages:function(item,user){return getItemController(item.Type).canEditImages(item,user)},canEditSubtitles:function(item,user){return getItemController(item.Type).canEditSubtitles(item,user)},canAddToPlaylist:function(item,user){return getItemController(item.Type).canAddToPlaylist(item,user)},canAddToCollection:function(item,user){return getItemController(item.Type).canAddToCollection(item,user)},canDownload:function(item){return getItemController(item.Type).canDownload(item)},canDownloadSubtitles:function(item,user){return getItemController(item.Type).canDownloadSubtitles(item,user)},canIdentify:function(item,user){return getItemController(item.Type).canIdentify(item,user)},canSync:function(item,user){return getItemController(item.Type).canSync(item,user)},canManageMultiVersionGrouping:function(item,user){return getItemController(item.Type).canManageMultiVersionGrouping(item,user)},canRefreshMetadata:function(item,user){return getItemController(item.Type).canRefreshMetadata(item,user)},canShare:function(item,user){return getItemController(item.Type).canShare(item,user)},getItemTypeName:function(type){return getItemController(type).getItemTypeName(type)},getAvailableFields:function(options){return getItemController(options.itemType).getAvailableFields(options)},getDefaultSorting:function(options){return getItemController(options.itemType).getDefaultSorting(options)},getSortMenuOptions:function(options){return getItemController(options.itemType).getSortMenuOptions(options)},getPluralItemTypeName:function(type){return getItemController(type).getPluralItemTypeName(type)},canRate:function(item){return getItemController(item.Type).canRate(item)},canMarkPlayed:function(item){return getItemController(item.Type).canMarkPlayed(item)},getCommands:function(options){var items=options.items;if(items||(items=[],options.item&&items.push(options.item)),!items.length)return[];for(var commands=getItemController(items[0].Type).getCommands(options),i=0,length=commandSources.length;i<length;i++)var subCommands=commandSources[i].getCommands(options),commands=commands.concat(subCommands);return commands},editItems:function(items,options){return items.length?getItemController(items[0].Type).editItems(items,options):rejectNoItems()},refreshMetadata:function(items,options){return items.length?getItemController(items[0].Type).refreshMetadata(items,options):rejectNoItems()},scanLibraryFiles:function(items,options){return items.length?getItemController(items[0].Type).scanLibraryFiles(items,options):rejectNoItems()},moveInOrder:function(items,options){return items.length?getItemController(items[0].Type).moveInOrder(items,options):rejectNoItems()},removeFromPlayQueue:function(items,options){return items.length?getItemController(items[0].Type).removeFromPlayQueue(items,options):rejectNoItems()},addToPlaylist:function(items,options){return items.length?getItemController(items[0].Type).addToPlaylist(items,options):rejectNoItems()},addToCollection:function(items,options){return items.length?getItemController(items[0].Type).addToCollection(items,options):rejectNoItems()},showDeleteConfirmation:function(options){var items=options.items;return items.length?getItemController(items[0].Type).showDeleteConfirmation(options):rejectNoItems()},deleteItems:function(options){var items=options.items;return items.length?getItemController(items[0].Type).deleteItems(options):rejectNoItems()},getContentTypeName:function(contentType){if(!contentType)return _globalize.default.translate("MixedContent");switch(contentType){case"movies":return _globalize.default.translate("Movies");case"music":return _globalize.default.translate("Music");case"tvshows":return _globalize.default.translate("TVShows");case"books":return _globalize.default.translate("Books");case"games":return _globalize.default.translate("Games");case"musicvideos":return _globalize.default.translate("MusicVideos");case"homevideos":return _globalize.default.translate("HomeVideosAndPhotos");case"audiobooks":return _globalize.default.translate("AudioBooks");case"boxsets":return _globalize.default.translate("Collections");case"playlists":return _globalize.default.translate("Playlists");default:return contentType}},groupVersions:function(items,options){return items.length?getItemController(items[0].Type).groupVersions(items,options):rejectNoItems()},executeCommand:function(command,items,options){return getItemController(items[0].Type).executeCommand(command,items,options).catch(function(err){if("nocommands"!==err)return Promise.reject(err);var commandSource,commandSourceOptions=Object.assign({},options);commandSourceOptions.items=items;for(var i=0,commandSourcesLength=commandSources.length;i<commandSourcesLength;i++){for(var subCommands=commandSources[i].getCommands(commandSourceOptions),subCommand=void 0,j=0,subCommandsLength=subCommands.length;j<subCommandsLength;j++)if(subCommands[j].id===command){subCommand=subCommands[j];break}if(subCommand){commandSource=commandSources[i];break}}return commandSource?commandSource.executeCommand(command,items,options):Promise.reject("nocommands")})},addToListHelper:function(list,itemIds){return itemIds.length?DefaultItemControllerInstance.addToListHelper(list,itemIds):rejectNoItems()},supportsSimilarItems:function(item){switch(item.Type){case"Movie":case"Trailer":case"Series":case"Program":case"Recording":case"Game":case"MusicAlbum":case"MusicArtist":case"MusicVideo":return!0;case"Timer":return null!=item.ProgramId;default:return!1}},supportsSimilarItemsOnLiveTV:function(item,apiClient){item.Type;return!1},enableDateAddedDisplay:function(item){var itemType=item.Type;return!item.IsFolder&&item.MediaType&&"Program"!==itemType&&"TvChannel"!==itemType&&"Trailer"!==itemType},createListHelper:function(apiClient,type,name,itemIds){return DefaultItemControllerInstance.createListHelper(apiClient,type,name,itemIds)}}});