/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.ClassBuilder;
import io.github.dmlloyd.classfile.ClassElement;
import io.github.dmlloyd.classfile.ClassFileTransform;
import io.github.dmlloyd.classfile.CodeTransform;
import io.github.dmlloyd.classfile.FieldTransform;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.MethodTransform;
import io.github.dmlloyd.classfile.impl.TransformImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface ClassTransform
extends ClassFileTransform<ClassTransform, ClassElement, ClassBuilder> {
    public static final ClassTransform ACCEPT_ALL = new ClassTransform(){

        @Override
        public void accept(ClassBuilder builder, ClassElement element) {
            builder.with(element);
        }
    };

    public static ClassTransform ofStateful(Supplier<ClassTransform> supplier) {
        return new TransformImpl.SupplierClassTransform(Objects.requireNonNull(supplier));
    }

    public static ClassTransform endHandler(final Consumer<ClassBuilder> finisher) {
        Objects.requireNonNull(finisher);
        return new ClassTransform(){

            @Override
            public void accept(ClassBuilder builder, ClassElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(ClassBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static ClassTransform dropping(Predicate<ClassElement> filter) {
        Objects.requireNonNull(filter);
        return (b, e) -> {
            if (!filter.test((ClassElement)e)) {
                b.with(e);
            }
        };
    }

    public static ClassTransform transformingMethods(Predicate<MethodModel> filter, MethodTransform xform) {
        return new TransformImpl.ClassMethodTransform(Objects.requireNonNull(xform), Objects.requireNonNull(filter));
    }

    public static ClassTransform transformingMethods(MethodTransform xform) {
        return ClassTransform.transformingMethods(__ -> true, xform);
    }

    public static ClassTransform transformingMethodBodies(Predicate<MethodModel> filter, CodeTransform xform) {
        return ClassTransform.transformingMethods(filter, MethodTransform.transformingCode(xform));
    }

    public static ClassTransform transformingMethodBodies(CodeTransform xform) {
        return ClassTransform.transformingMethods(MethodTransform.transformingCode(xform));
    }

    public static ClassTransform transformingFields(FieldTransform xform) {
        return new TransformImpl.ClassFieldTransform(Objects.requireNonNull(xform), __ -> true);
    }

    @Override
    default public ClassTransform andThen(ClassTransform t) {
        return new TransformImpl.ChainedClassTransform(this, Objects.requireNonNull(t));
    }
}

