/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.sandbox.facet.FacetFieldCollector;
import org.apache.lucene.sandbox.facet.FacetFieldCollectorManager;
import org.apache.lucene.sandbox.facet.utils.FacetBuilder;
import org.apache.lucene.sandbox.facet.utils.FacetOrchestrator;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.MultiCollectorManager;

public final class DrillSidewaysFacetOrchestrator {
    private List<FacetBuilder> drillDownFacetBuilders = new ArrayList<FacetBuilder>();
    private Map<String, Integer> dimToIndex = new HashMap<String, Integer>();
    private Map<Integer, List<FacetBuilder>> drillSidewaysFacetBuilders = new HashMap<Integer, List<FacetBuilder>>();

    public DrillSidewaysFacetOrchestrator addDrillSidewaysBuilder(String dim, FacetBuilder facetBuilder) {
        int dimIndex = this.dimToIndex.computeIfAbsent(dim, x -> this.dimToIndex.size());
        this.drillSidewaysFacetBuilders.computeIfAbsent(dimIndex, x -> new ArrayList()).add(facetBuilder);
        return this;
    }

    public DrillSidewaysFacetOrchestrator addDrillDownBuilder(FacetBuilder facetBuilder) {
        this.drillDownFacetBuilders.add(facetBuilder);
        return this;
    }

    public void collect(DrillDownQuery query, DrillSideways drillSideways) throws IOException {
        this.collect(query, drillSideways, null);
    }

    public <T> T collect(DrillDownQuery query, DrillSideways drillSideways, CollectorManager<? extends Collector, T> mainCollector) throws IOException {
        MultiCollectorManager drillDownManager = FacetOrchestrator.createMainCollector(this.drillDownFacetBuilders, mainCollector);
        ArrayList<VoidFacetFieldCollectorManager> drillSidewaysManagers = new ArrayList<VoidFacetFieldCollectorManager>();
        for (int i = 0; i < this.drillSidewaysFacetBuilders.size(); ++i) {
            List<FacetFieldCollectorManager<?>> managers = FacetOrchestrator.collectorManagerForBuilders(this.drillSidewaysFacetBuilders.get(i));
            if (managers.size() != 1) {
                throw new IllegalArgumentException("Expected exactly one collector manager per dimension but got " + managers.size());
            }
            drillSidewaysManagers.add(new VoidFacetFieldCollectorManager(managers.getFirst()));
        }
        DrillSideways.Result result = drillSideways.search(query, (CollectorManager)drillDownManager, drillSidewaysManagers);
        if (mainCollector != null) {
            return (T)result.drillDownResult();
        }
        return null;
    }

    private static final class VoidFacetFieldCollectorManager
    implements CollectorManager<FacetFieldCollector, Void> {
        private final FacetFieldCollectorManager<?> delegate;

        public VoidFacetFieldCollectorManager(FacetFieldCollectorManager<?> delegate) {
            this.delegate = delegate;
        }

        public FacetFieldCollector newCollector() throws IOException {
            return this.delegate.newCollector();
        }

        public Void reduce(Collection<FacetFieldCollector> collection) throws IOException {
            this.delegate.reduce((Collection)collection);
            return null;
        }
    }
}

