/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import net.osmand.data.RotatedTileBox;
import net.sourceforge.offroad.ui.OffRoadUIThread;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

class MoveAnimationThread
extends OffRoadUIThread {
    private final float mDeltaX;
    private final float mDeltaY;

    MoveAnimationThread(OsmBitmapPanel pOsmBitmapPanel, float pDeltaX, float pDeltaY) {
        super(pOsmBitmapPanel, "MoveAnimation");
        this.mDeltaX = pDeltaX;
        this.mDeltaY = pDeltaY;
    }

    @Override
    public void runAfterThreadsBeforeHaveFinished() {
        if (this.mNextThread == null) {
            int it = 30;
            float v0 = 2.0f;
            float a = ((float)it * (1.0f - v0) + 2.0f * v0 - 2.0f) / ((float)it - 2.0f) / ((float)it - 2.0f);
            float accumulatedX = 0.0f;
            float accumulatedY = 0.0f;
            for (int i = 0; i < it - 1; ++i) {
                float delta = v0 * (float)i + a * (float)i * (float)i;
                RotatedTileBox tb = this.mOsmBitmapPanel.moveTileBox(-accumulatedX + this.mDeltaX * delta / (float)it, -accumulatedY + this.mDeltaY * delta / (float)it);
                accumulatedX = this.mDeltaX * delta / (float)it;
                accumulatedY = this.mDeltaY * delta / (float)it;
                this.mOsmBitmapPanel.repaintAndWait(50);
            }
            RotatedTileBox rotatedTileBox = this.mOsmBitmapPanel.moveTileBox(-accumulatedX + this.mDeltaX, -accumulatedY + this.mDeltaY);
        } else {
            int it = 10;
            for (int i = 0; i < it; ++i) {
                RotatedTileBox tb = this.mOsmBitmapPanel.moveTileBox(this.mDeltaX / (float)it, this.mDeltaY / (float)it);
                this.mOsmBitmapPanel.repaintAndWait(50);
            }
        }
    }
}

