/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.config.Field;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.extractor.BasicEmbeddedBytesSelector;
import org.apache.tika.extractor.EmbeddedBytesSelector;
import org.apache.tika.extractor.EmbeddedDocumentByteStoreExtractorFactory;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.RUnpackExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;

public class RUnpackExtractorFactory
implements EmbeddedDocumentByteStoreExtractorFactory {
    public static long DEFAULT_MAX_EMBEDDED_BYTES_FOR_EXTRACTION = 0x280000000L;
    private boolean writeFileNameToContent = true;
    private Set<String> embeddedBytesIncludeMimeTypes = Collections.EMPTY_SET;
    private Set<String> embeddedBytesExcludeMimeTypes = Collections.EMPTY_SET;
    private Set<String> embeddedBytesIncludeEmbeddedResourceTypes = Collections.EMPTY_SET;
    private Set<String> embeddedBytesExcludeEmbeddedResourceTypes = Collections.EMPTY_SET;
    private long maxEmbeddedBytesForExtraction = DEFAULT_MAX_EMBEDDED_BYTES_FOR_EXTRACTION;

    @Field
    public void setWriteFileNameToContent(boolean writeFileNameToContent) {
        this.writeFileNameToContent = writeFileNameToContent;
    }

    @Field
    public void setEmbeddedBytesIncludeMimeTypes(List<String> includeMimeTypes) {
        this.embeddedBytesIncludeMimeTypes = new HashSet<String>();
        this.embeddedBytesIncludeMimeTypes.addAll(includeMimeTypes);
    }

    @Field
    public void setEmbeddedBytesExcludeMimeTypes(List<String> excludeMimeTypes) {
        this.embeddedBytesExcludeMimeTypes = new HashSet<String>();
        this.embeddedBytesExcludeMimeTypes.addAll(excludeMimeTypes);
    }

    @Field
    public void setEmbeddedBytesIncludeEmbeddedResourceTypes(List<String> includeAttachmentTypes) {
        this.embeddedBytesIncludeEmbeddedResourceTypes = new HashSet<String>();
        this.embeddedBytesIncludeEmbeddedResourceTypes.addAll(includeAttachmentTypes);
    }

    @Field
    public void setEmbeddedBytesExcludeEmbeddedResourceTypes(List<String> excludeAttachmentTypes) {
        this.embeddedBytesExcludeEmbeddedResourceTypes = new HashSet<String>();
        this.embeddedBytesExcludeEmbeddedResourceTypes.addAll(excludeAttachmentTypes);
    }

    @Field
    public void setMaxEmbeddedBytesForExtraction(long maxEmbeddedBytesForExtraction) throws TikaConfigException {
        if (maxEmbeddedBytesForExtraction < 0L) {
            throw new TikaConfigException("maxEmbeddedBytesForExtraction must be >= 0");
        }
        this.maxEmbeddedBytesForExtraction = maxEmbeddedBytesForExtraction;
    }

    @Override
    public EmbeddedDocumentExtractor newInstance(Metadata metadata, ParseContext parseContext) {
        RUnpackExtractor ex = new RUnpackExtractor(parseContext, this.maxEmbeddedBytesForExtraction);
        ex.setWriteFileNameToContent(this.writeFileNameToContent);
        ex.setEmbeddedBytesSelector(this.createEmbeddedBytesSelector());
        return ex;
    }

    private EmbeddedBytesSelector createEmbeddedBytesSelector() {
        if (this.embeddedBytesIncludeMimeTypes.size() == 0 && this.embeddedBytesExcludeMimeTypes.size() == 0 && this.embeddedBytesIncludeEmbeddedResourceTypes.size() == 0 && this.embeddedBytesExcludeEmbeddedResourceTypes.size() == 0) {
            return EmbeddedBytesSelector.ACCEPT_ALL;
        }
        return new BasicEmbeddedBytesSelector(this.embeddedBytesIncludeMimeTypes, this.embeddedBytesExcludeMimeTypes, this.embeddedBytesIncludeEmbeddedResourceTypes, this.embeddedBytesExcludeEmbeddedResourceTypes);
    }
}

