/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class DefaultNodeSet<E extends OWLObject>
implements NodeSet<E> {
    private final Set<Node<E>> nodes = new LinkedHashSet<Node<E>>();

    public DefaultNodeSet() {
    }

    public DefaultNodeSet(@Nonnull E entity) {
        this.addNode(this.getNode((OWLObject)OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null")));
    }

    public DefaultNodeSet(@Nonnull Node<E> node) {
        this.addNode(OWLAPIPreconditions.checkNotNull(node, "node cannot be null"));
    }

    public DefaultNodeSet(@Nonnull Set<Node<E>> nodes) {
        this.addAllNodes((Collection)OWLAPIPreconditions.checkNotNull(nodes, "nodes cannot be null"));
    }

    @Override
    @Nonnull
    public Set<Node<E>> getNodes() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.nodes);
    }

    public void addEntity(@Nonnull E entity) {
        this.addNode(this.getNode((OWLObject)OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null")));
    }

    public void addNode(@Nonnull Node<E> node) {
        this.nodes.add(OWLAPIPreconditions.checkNotNull(node, "Cannot add null to a NodeSet"));
    }

    public void addAllNodes(@Nonnull Collection<Node<E>> nodeset) {
        for (Node<E> node : nodeset) {
            assert (node != null);
            this.addNode(node);
        }
    }

    public void addSameEntities(@Nonnull Set<E> entities) {
        this.nodes.add(this.getNode(entities));
    }

    public void addDifferentEntities(@Nonnull Set<E> entities) {
        for (OWLObject e : entities) {
            assert (e != null);
            this.addNode(this.getNode(e));
        }
    }

    @Nonnull
    protected abstract DefaultNode<E> getNode(@Nonnull E var1);

    @Nonnull
    protected abstract DefaultNode<E> getNode(@Nonnull Set<E> var1);

    @Override
    @Nonnull
    public Set<E> getFlattened() {
        HashSet<E> result = new HashSet<E>();
        for (Node<E> node : this.nodes) {
            result.addAll(node.getEntities());
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean containsEntity(E e) {
        for (Node<E> node : this.nodes) {
            if (!node.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSingleton() {
        return this.nodes.size() == 1;
    }

    @Override
    public boolean isTopSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isTopNode();
    }

    @Override
    public boolean isBottomSingleton() {
        return this.isSingleton() && this.nodes.iterator().next().isBottomNode();
    }

    @Override
    public Iterator<Node<E>> iterator() {
        return this.nodes.iterator();
    }

    public String toString() {
        return "Nodeset" + this.nodes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NodeSet)) {
            return false;
        }
        NodeSet other = (NodeSet)obj;
        return this.nodes.equals(other.getNodes());
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }
}

