/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.authentication.TotpAuthenticationCredentials;
import org.zaproxy.zap.utils.ZapNumberSpinner;
import org.zaproxy.zap.utils.ZapTextField;

public class TotpTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private ZapTextField totpSecretTextField;
    private ZapNumberSpinner totpPeriodNumberSpinner;
    private ZapNumberSpinner totpDigitsNumberSpinner;
    private JComboBox<String> totpAlgorithmComboBox;
    private JPanel totpPanel;

    public TotpTabbedPane(JPanel credentialsPanel) {
        this.addTab(Constant.messages.getString("authentication.method.all.credentials.totp.ui.tab.creds"), credentialsPanel);
        this.totpPanel = new JPanel();
        GroupLayout layout = new GroupLayout(this.totpPanel);
        this.totpPanel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        this.totpSecretTextField = new ZapTextField(25);
        JLabel totpSecretLabel = TotpTabbedPane.createLabel("secret", this.totpSecretTextField);
        this.totpPeriodNumberSpinner = new ZapNumberSpinner(1, TotpAuthenticationCredentials.TotpData.EMPTY.period(), Integer.MAX_VALUE);
        JLabel totpPeriodLabel = TotpTabbedPane.createLabel("period", this.totpPeriodNumberSpinner);
        this.totpDigitsNumberSpinner = new ZapNumberSpinner(1, TotpAuthenticationCredentials.TotpData.EMPTY.digits(), Integer.MAX_VALUE);
        JLabel totpDigitsLabel = TotpTabbedPane.createLabel("digits", this.totpDigitsNumberSpinner);
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        TotpAuthenticationCredentials.getGenerator().getSupportedAlgorithms().forEach(model::addElement);
        this.totpAlgorithmComboBox = new JComboBox(model);
        JLabel totpAlgorithmLabel = TotpTabbedPane.createLabel("algorithm", this.totpAlgorithmComboBox);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(totpSecretLabel).addComponent(totpPeriodLabel).addComponent(totpDigitsLabel).addComponent(totpAlgorithmLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totpSecretTextField).addComponent(this.totpPeriodNumberSpinner).addComponent(this.totpDigitsNumberSpinner).addComponent(this.totpAlgorithmComboBox)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(totpSecretLabel).addComponent(this.totpSecretTextField)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(totpPeriodLabel).addComponent(this.totpPeriodNumberSpinner)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(totpDigitsLabel).addComponent(this.totpDigitsNumberSpinner)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(totpAlgorithmLabel).addComponent(this.totpAlgorithmComboBox)));
        this.addTab(Constant.messages.getString("authentication.method.all.credentials.totp.ui.tab.totp"), this.totpPanel);
    }

    private static JLabel createLabel(String key, JComponent field) {
        JLabel label = new JLabel(Constant.messages.getString("authentication.method.all.credentials.totp.ui.field." + key));
        label.setLabelFor(field);
        return label;
    }

    public void setTotpData(TotpAuthenticationCredentials.TotpData totpData) {
        this.totpSecretTextField.setText(totpData.secret());
        this.totpSecretTextField.discardAllEdits();
        this.totpPeriodNumberSpinner.setValue(totpData.period());
        this.totpDigitsNumberSpinner.setValue(totpData.digits());
        this.totpAlgorithmComboBox.setSelectedItem(totpData.algorithm());
    }

    public TotpAuthenticationCredentials.TotpData getTotpData() {
        return new TotpAuthenticationCredentials.TotpData(this.totpSecretTextField.getText(), this.totpPeriodNumberSpinner.getValue(), this.totpDigitsNumberSpinner.getValue(), (String)this.totpAlgorithmComboBox.getSelectedItem());
    }
}

