/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.injectors.AbstractInjector;
import org.picocontainer.parameters.BasicComponentParameter;
import org.picocontainer.parameters.CollectionComponentParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentParameter
extends BasicComponentParameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    public static final ComponentParameter ARRAY_ALLOW_EMPTY = new ComponentParameter(true);
    private final Parameter collectionParameter;

    public ComponentParameter(Object componentKey) {
        this(componentKey, null);
    }

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    public ComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentValueType, emptyCollection));
    }

    public ComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentKeyType, componentValueType, emptyCollection));
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        super(componentKey);
        this.collectionParameter = collectionParameter;
    }

    @Override
    public Parameter.Resolver resolve(final PicoContainer container, final ComponentAdapter<?> forAdapter, final ComponentAdapter<?> injecteeAdapter, final Type expectedType, final NameBinding expectedNameBinding, final boolean useNames, final Annotation binding) {
        return new Parameter.Resolver(){
            final Parameter.Resolver resolver;
            {
                this.resolver = ComponentParameter.super.resolve(container, forAdapter, injecteeAdapter, expectedType, expectedNameBinding, useNames, binding);
            }

            @Override
            public boolean isResolved() {
                boolean superResolved = this.resolver.isResolved();
                if (!superResolved) {
                    if (ComponentParameter.this.collectionParameter != null) {
                        return ComponentParameter.this.collectionParameter.resolve(container, forAdapter, null, expectedType, expectedNameBinding, useNames, binding).isResolved();
                    }
                    return false;
                }
                return superResolved;
            }

            @Override
            public Object resolveInstance() {
                Object result = null;
                if (expectedType instanceof Class) {
                    result = ComponentParameter.super.resolve(container, forAdapter, injecteeAdapter, expectedType, expectedNameBinding, useNames, binding).resolveInstance();
                } else if (expectedType instanceof ParameterizedType) {
                    result = ComponentParameter.super.resolve(container, forAdapter, injecteeAdapter, ((ParameterizedType)expectedType).getRawType(), expectedNameBinding, useNames, binding).resolveInstance();
                }
                if (result == null && ComponentParameter.this.collectionParameter != null) {
                    result = ComponentParameter.this.collectionParameter.resolve(container, forAdapter, injecteeAdapter, expectedType, expectedNameBinding, useNames, binding).resolveInstance();
                }
                return result;
            }

            @Override
            public ComponentAdapter<?> getComponentAdapter() {
                return this.resolver.getComponentAdapter();
            }
        };
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        try {
            super.verify(container, adapter, expectedType, expectedNameBinding, useNames, binding);
        }
        catch (AbstractInjector.UnsatisfiableDependenciesException e) {
            if (this.collectionParameter != null) {
                this.collectionParameter.verify(container, adapter, expectedType, expectedNameBinding, useNames, binding);
                return;
            }
            throw e;
        }
    }

    @Override
    public void accept(PicoVisitor visitor) {
        super.accept(visitor);
        if (this.collectionParameter != null) {
            this.collectionParameter.accept(visitor);
        }
    }
}

