/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.project.api.Workspace;
import org.gephi.statistics.plugin.ConnectedComponents;
import org.openide.util.NbBundle;

public class GiantComponentBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new GiantComponentFilter();
    }

    public JPanel getPanel(Filter filter) {
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class GiantComponentFilter
    implements NodeFilter {
        private static final String GIANT_COMPONENT_FILTER = "giantcomponent";
        private int componentId;
        private Column column;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean init(Graph graph) {
            ConnectedComponents cc = new ConnectedComponents();
            UndirectedSubgraph undirectedGraph = graph.getModel().getUndirectedGraph(graph.getView());
            this.column = graph.getModel().getNodeTable().getColumn(GIANT_COMPONENT_FILTER);
            if (this.column == null) {
                this.column = graph.getModel().getNodeTable().addColumn(GIANT_COMPONENT_FILTER, Integer.class);
            }
            graph.readLock();
            try {
                cc.weaklyConnected((UndirectedGraph)undirectedGraph, this.column);
            }
            finally {
                graph.readUnlock();
            }
            this.componentId = cc.getGiantComponent();
            return this.column != null && this.componentId != -1;
        }

        public boolean evaluate(Graph graph, Node node) {
            Integer component = (Integer)node.getAttribute(this.column);
            if (component != null) {
                return component.equals(this.componentId);
            }
            return false;
        }

        public void finish() {
            this.column.getTable().removeColumn(this.column);
        }

        public String getName() {
            return NbBundle.getMessage(GiantComponentBuilder.class, (String)"GiantComponentBuilder.name");
        }

        public FilterProperty[] getProperties() {
            return new FilterProperty[0];
        }
    }
}

