/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReferenceKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnResolutionContext;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002J\b\u0010\b\u001a\u00020\tH&J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000b\u001a\u00020\tH&J\b\u0010\f\u001a\u00020\rH\u0016J\u001d\u0010\u0003\u001a\u00028\u00002\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u00030\u000fj\u0002`\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u00030\u000fj\u0002`\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "C", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "getValue", "thisRef", "", "property", "Lkotlin/reflect/KProperty;", "name", "", "rename", "newName", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "row", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "Lorg/jetbrains/kotlinx/dataframe/AnyRow;", "(Lorg/jetbrains/kotlinx/dataframe/DataRow;)Ljava/lang/Object;", "getValueOrNull", "resolveSingle", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "context", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnResolutionContext;", "core"})
public interface ColumnReference<C>
extends SingleColumn<C> {
    @NotNull
    default public ColumnReference<C> getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return ColumnReferenceKt.renamedReference(this, UtilsKt.getColumnName(property));
    }

    @NotNull
    public String name();

    @NotNull
    public ColumnReference<C> rename(@NotNull String var1);

    @NotNull
    default public ColumnPath path() {
        return new ColumnPath(ColumnReferenceApiKt.getName(this));
    }

    default public C getValue(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        ColumnWithPath columnWithPath = ColumnReferenceKt.resolveFor(this, row.df());
        Intrinsics.checkNotNull(columnWithPath);
        return (C)columnWithPath.get(row.index());
    }

    @Nullable
    default public C getValueOrNull(@NotNull DataRow<?> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        ColumnWithPath columnWithPath = ColumnReferenceKt.resolveFor(this, row.df());
        return columnWithPath != null ? (C)columnWithPath.get(row.index()) : null;
    }

    @Override
    @Nullable
    default public ColumnWithPath<C> resolveSingle(@NotNull ColumnResolutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DataColumn dataColumn = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.getColumn((ColumnsContainer)context.getDf(), this.path(), context.getUnresolvedColumnsPolicy());
        return dataColumn != null ? org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.addPath(dataColumn, this.path()) : null;
    }
}

