/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.push.HgOutgoingCommitsProvider;
import org.zmlx.hg4idea.push.HgPushOptionsPanel;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgPushTargetPanel;
import org.zmlx.hg4idea.push.HgPusher;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushSupport
extends PushSupport<HgRepository, HgPushSource, HgTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings mySettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    public HgPushSupport(@NotNull Project project) {
        if (project == null) {
            HgPushSupport.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVcs = Objects.requireNonNull(HgVcs.getInstance(this.myProject));
        this.mySettings = this.myVcs.getProjectSettings();
        this.myCommonPushSettings = (PushSettings)project.getService(PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            HgPushSupport.$$$reportNull$$$0(1);
        }
        return hgVcs;
    }

    @NotNull
    public Pusher<HgRepository, HgPushSource, HgTarget> getPusher() {
        return new HgPusher();
    }

    @NotNull
    public OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> getOutgoingCommitsProvider() {
        return new HgOutgoingCommitsProvider();
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository) {
        String defaultPushPath;
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(2);
        }
        return (defaultPushPath = repository.getRepositoryConfig().getDefaultPushPath()) == null ? null : new HgTarget(defaultPushPath, Objects.requireNonNull(repository.getCurrentBranchName()));
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository, @NotNull HgPushSource source) {
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(3);
        }
        if (source == null) {
            HgPushSupport.$$$reportNull$$$0(4);
        }
        return this.getDefaultTarget(repository);
    }

    public HgPushSource getSource(@NotNull HgRepository repository) {
        String localBranch;
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(5);
        }
        if ((localBranch = repository.getCurrentBranchName()) == null) {
            return null;
        }
        return new HgPushSource(localBranch);
    }

    @NotNull
    public RepositoryManager<HgRepository> getRepositoryManager() {
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(this.myProject);
        if (hgRepositoryManager == null) {
            HgPushSupport.$$$reportNull$$$0(6);
        }
        return hgRepositoryManager;
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new HgPushOptionsPanel();
    }

    @NotNull
    public PushTargetPanel<HgTarget> createTargetPanel(@NotNull HgRepository repository, @NotNull HgPushSource source, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            HgPushSupport.$$$reportNull$$$0(7);
        }
        if (source == null) {
            HgPushSupport.$$$reportNull$$$0(8);
        }
        return new HgPushTargetPanel(repository, source, defaultTarget);
    }

    public boolean isForcePushAllowed(@NotNull HgRepository repo, @NotNull HgTarget target) {
        if (repo == null) {
            HgPushSupport.$$$reportNull$$$0(9);
        }
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(10);
        }
        return true;
    }

    public boolean shouldRequestIncomingChangesForNotCheckedRepositories() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    public void saveSilentForcePushTarget(@NotNull HgTarget target) {
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(11);
        }
        this.myCommonPushSettings.addForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    public boolean isSilentForcePushAllowed(@NotNull HgTarget target) {
        if (target == null) {
            HgPushSupport.$$$reportNull$$$0(12);
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/push/HgPushSupport";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/push/HgPushSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTarget";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSource";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTargetPanel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isForcePushAllowed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveSilentForcePushTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSilentForcePushAllowed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6 -> new IllegalStateException(string);
        };
    }
}

