/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.Iterators;

public final class RW {
    private static final int STRING_HEADER_SIZE = 1;
    private static final int STRING_LENGTH_THRESHOLD = 255;
    private static final String LONGER_THAN_64K_MARKER = "LONGER_THAN_64K";
    private static final ThreadLocal<SoftReference<byte[]>> ourBuffersCache = new ThreadLocal();

    private RW() {
    }

    public static <T> void writeCollection(DataOutput out, Iterable<? extends T> seq, Writer<? super T> writable) throws IOException {
        Collection col = seq instanceof Collection ? (Collection)seq : Iterators.collect(seq, new ArrayList());
        out.writeInt(col.size());
        for (Object t : col) {
            writable.write(t);
        }
    }

    public static <T> List<T> readCollection(DataInput in, Reader<? extends T> reader) throws IOException {
        return RW.readCollection(in, reader, new ArrayList());
    }

    public static <T, C extends Collection<? super T>> C readCollection(DataInput in, Reader<? extends T> reader, C acc) throws IOException {
        int size = in.readInt();
        while (size-- > 0) {
            acc.add(reader.read());
        }
        return acc;
    }

    public static void writeUTF(@NotNull DataOutput storage, @NotNull CharSequence value) throws IOException {
        if (storage == null) {
            RW.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RW.$$$reportNull$$$0(1);
        }
        RW.writeUTFFast(RW.getBuffer(), storage, value);
    }

    public static String readUTF(@NotNull DataInput storage) throws IOException {
        if (storage == null) {
            RW.$$$reportNull$$$0(2);
        }
        return RW.readUTFFast(RW.getBuffer(), storage);
    }

    private static void writeUTFFast(byte @NotNull [] buffer, @NotNull DataOutput storage, @NotNull CharSequence value) throws IOException {
        int len;
        if (storage == null) {
            RW.$$$reportNull$$$0(3);
        }
        if (value == null) {
            RW.$$$reportNull$$$0(4);
        }
        if (buffer == null) {
            RW.$$$reportNull$$$0(5);
        }
        if ((len = value.length()) < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value.toString());
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF(LONGER_THAN_64K_MARKER);
            RW.writeCharSequence(value, storage);
        }
    }

    private static void writeCharSequence(@Nullable CharSequence s, @NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            RW.$$$reportNull$$$0(6);
        }
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.length() == 0) {
            return;
        }
        byte[] bytes = new byte[s.length() * 2];
        int i = 0;
        int i2 = 0;
        while (i < s.length()) {
            char aChar = s.charAt(i);
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    private static String readUTFFast(byte @NotNull [] buffer, @NotNull DataInput storage) throws IOException {
        int len;
        if (storage == null) {
            RW.$$$reportNull$$$0(7);
        }
        if (buffer == null) {
            RW.$$$reportNull$$$0(8);
        }
        if ((len = 0xFF & storage.readByte()) == 255) {
            String result = storage.readUTF();
            if (LONGER_THAN_64K_MARKER.equals(result)) {
                return RW.readString(storage);
            }
            return result;
        }
        if (len == 0) {
            return "";
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, StandardCharsets.ISO_8859_1);
    }

    private static String readString(@NotNull DataInput stream) throws IOException {
        if (stream == null) {
            RW.$$$reportNull$$$0(9);
        }
        try {
            int length = stream.readInt();
            if (length == -1) {
                return null;
            }
            if (length == 0) {
                return "";
            }
            byte[] bytes = new byte[length * 2];
            stream.readFully(bytes);
            return new String(bytes, 0, length * 2, StandardCharsets.UTF_16BE);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static byte[] getBuffer() {
        byte[] buf;
        SoftReference<byte[]> ref = ourBuffersCache.get();
        byte[] byArray = buf = ref != null ? ref.get() : null;
        if (buf == null) {
            buf = new byte[256];
            ourBuffersCache.set(new SoftReference<byte[]>(buf));
        }
        return buf;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/dependency/impl/RW";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUTF";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readUTF";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeUTFFast";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeCharSequence";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readUTFFast";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "readString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Writer<T> {
        public void write(T var1) throws IOException;
    }

    public static interface Reader<T> {
        public T read() throws IOException;
    }
}

