/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the pixel-wise maximum of several images.


This class is templated over the types of the input images and the
type of the output image. Numeric conversions (castings) are done by
the C++ defaults.

The pixel type of the output images must have a valid definition of
the operator&lt;. This condition is required because internally this
filter will perform an operation similar to:

 (where current_maximum is also of type OutputPixelType)

for each of the n input images.

For example, this filter could be used directly to find a "maximum
projection" of a series of images, often used in preliminary analysis
of time-series data.


Zachary Pincus
 This filter was contributed by Zachary Pincus from the Department of
Biochemistry and Program in Biomedical Informatics at Stanford
University School of Medicine


See:
 itk::simple::NaryMaximum for the procedural interface


C++ includes: sitkNaryMaximumImageFilter.h
*/
public class NaryMaximumImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected NaryMaximumImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.NaryMaximumImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NaryMaximumImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(NaryMaximumImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::NaryMaximumImageFilter::~NaryMaximumImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_NaryMaximumImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::NaryMaximumImageFilter::NaryMaximumImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  NaryMaximumImageFilter() {
    this(SimpleITKJNI.new_NaryMaximumImageFilter(), true);
  }

  /**
std::string itk::simple::NaryMaximumImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.NaryMaximumImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::NaryMaximumImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.NaryMaximumImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::NaryMaximumImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.NaryMaximumImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
