/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.preferences.ListProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.ApiUrlTestTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OsmApiUrlInputPanel
extends JPanel {
    public static final String API_URL_PROP = OsmApiUrlInputPanel.class.getName() + ".apiUrl";
    private final JLabel lblValid = new JLabel();
    private final JLabel lblApiUrl = new JLabel(I18n.tr("OSM Server URL:", new Object[0]));
    private final HistoryComboBox tfOsmServerUrl = new HistoryComboBox();
    private transient ApiUrlValidator valOsmServerUrl;
    private JButton btnTest;
    private JCheckBox cbUseDefaultServerUrl;
    private final transient ListProperty SERVER_URL_HISTORY = new ListProperty("osm-server.url-history", Arrays.asList("https://api06.dev.openstreetmap.org/api", "https://master.apis.dev.openstreetmap.org/api"));
    private transient ApiUrlPropagator propagator;

    public OsmApiUrlInputPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ApiUrl"));
    }

    protected JComponent buildDefaultServerUrlPanel() {
        this.cbUseDefaultServerUrl = new JCheckBox(I18n.tr("<html>Use the default OSM server URL (<strong>{0}</strong>)</html>", Config.getUrls().getDefaultOsmApiUrl()));
        this.cbUseDefaultServerUrl.addItemListener(new UseDefaultServerUrlChangeHandler());
        this.cbUseDefaultServerUrl.setFont(this.cbUseDefaultServerUrl.getFont().deriveFont(0));
        return this.cbUseDefaultServerUrl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.buildDefaultServerUrlPanel(), GBC.eop().fill(2));
        this.add((Component)this.lblApiUrl, GBC.std().insets(0, 0, 3, 0));
        this.add((Component)this.tfOsmServerUrl, GBC.std().fill(2).insets(0, 0, 3, 0));
        this.lblApiUrl.setLabelFor(this.tfOsmServerUrl);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmServerUrl.getEditorComponent());
        this.valOsmServerUrl = new ApiUrlValidator(this.tfOsmServerUrl.getEditorComponent());
        this.valOsmServerUrl.validate();
        this.propagator = new ApiUrlPropagator();
        this.tfOsmServerUrl.addActionListener(this.propagator);
        this.tfOsmServerUrl.addFocusListener(this.propagator);
        this.add((Component)this.lblValid, GBC.std().insets(0, 0, 3, 0));
        ValidateApiUrlAction actTest = new ValidateApiUrlAction();
        this.tfOsmServerUrl.getEditorComponent().getDocument().addDocumentListener(actTest);
        this.btnTest = new JButton(actTest);
        this.add((Component)this.btnTest, GBC.eop());
    }

    public void initFromPreferences() {
        String url = OsmApi.getOsmApi().getServerUrl();
        this.tfOsmServerUrl.getModel().prefs().load(this.SERVER_URL_HISTORY);
        if (Config.getUrls().getDefaultOsmApiUrl().equals(url.trim())) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.propagator.propagate(Config.getUrls().getDefaultOsmApiUrl());
        } else {
            this.cbUseDefaultServerUrl.setSelected(false);
            this.tfOsmServerUrl.setText(url);
            this.propagator.propagate(url);
        }
    }

    public void saveToPreferences() {
        String oldUrl = OsmApi.getOsmApi().getServerUrl();
        String hmiUrl = this.getStrippedApiUrl();
        if (this.cbUseDefaultServerUrl.isSelected() || Config.getUrls().getDefaultOsmApiUrl().equals(hmiUrl)) {
            Config.getPref().put("osm-server.url", null);
        } else {
            Config.getPref().put("osm-server.url", hmiUrl);
            this.tfOsmServerUrl.addCurrentItemToHistory();
            this.tfOsmServerUrl.getModel().prefs().save(this.SERVER_URL_HISTORY);
        }
        String newUrl = OsmApi.getOsmApi().getServerUrl();
        if (!oldUrl.equals(newUrl)) {
            try {
                OsmApi.getOsmApi().initialize(null);
            }
            catch (OsmApiInitializationException | OsmTransferCanceledException ex) {
                Logging.warn(ex);
            }
        }
    }

    public final String getStrippedApiUrl() {
        return Utils.strip(this.tfOsmServerUrl.getText());
    }

    public void setApiUrlInputEnabled(boolean enabled) {
        this.lblApiUrl.setEnabled(enabled);
        this.tfOsmServerUrl.setEnabled(enabled);
        this.lblValid.setEnabled(enabled);
        this.btnTest.setEnabled(enabled);
    }

    class ApiUrlPropagator
    extends FocusAdapter
    implements ActionListener {
        ApiUrlPropagator() {
        }

        protected void propagate() {
            this.propagate(OsmApiUrlInputPanel.this.getStrippedApiUrl());
        }

        protected void propagate(String url) {
            OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, url);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.propagate();
        }

        @Override
        public void focusLost(FocusEvent arg0) {
            this.propagate();
        }
    }

    class UseDefaultServerUrlChangeHandler
    implements ItemListener {
        UseDefaultServerUrlChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            switch (e.getStateChange()) {
                case 1: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(false);
                    OsmApiUrlInputPanel.this.propagator.propagate(Config.getUrls().getDefaultOsmApiUrl());
                    break;
                }
                case 2: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(true);
                    OsmApiUrlInputPanel.this.valOsmServerUrl.validate();
                    OsmApiUrlInputPanel.this.tfOsmServerUrl.requestFocusInWindow();
                    OsmApiUrlInputPanel.this.propagator.propagate();
                    break;
                }
            }
        }
    }

    private static class ApiUrlValidator
    extends AbstractTextComponentValidator {
        ApiUrlValidator(JTextComponent tc) {
            super(tc);
        }

        @Override
        public boolean isValid() {
            if (this.getComponent().getText().trim().isEmpty()) {
                return false;
            }
            return Utils.isValidUrl(this.getComponent().getText().trim());
        }

        @Override
        public void validate() {
            if (this.getComponent().getText().trim().isEmpty()) {
                this.feedbackInvalid(I18n.tr("OSM API URL must not be empty. Please enter the OSM API URL.", new Object[0]));
                return;
            }
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid URL", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter the OSM API URL.", new Object[0]));
            }
        }
    }

    class ValidateApiUrlAction
    extends AbstractAction
    implements DocumentListener {
        private String lastTestedUrl;

        ValidateApiUrlAction() {
            this.putValue("Name", I18n.tr("Validate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Test the API URL", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String url = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            ApiUrlTestTask task = new ApiUrlTestTask(OsmApiUrlInputPanel.this, url);
            MainApplication.worker.submit(task);
            Runnable r = () -> {
                if (task.isCanceled()) {
                    return;
                }
                Runnable r1 = () -> {
                    if (task.isSuccess()) {
                        OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("misc", "green_check"));
                        OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("The API URL is valid.", new Object[0]));
                        this.lastTestedUrl = url;
                        this.updateEnabledState();
                    } else {
                        OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
                        OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("Validation failed. The API URL seems to be invalid.", new Object[0]));
                    }
                };
                SwingUtilities.invokeLater(r1);
            };
            MainApplication.worker.submit(r);
        }

        protected final void updateEnabledState() {
            boolean enabled;
            String url = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            boolean bl = enabled = !url.isEmpty() && !url.equals(this.lastTestedUrl);
            if (enabled) {
                OsmApiUrlInputPanel.this.lblValid.setIcon(null);
            }
            this.setEnabled(enabled);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.updateEnabledState();
        }
    }
}

