/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { createContext, useContext } from 'react';
var EuiResizableContainerContext = /*#__PURE__*/createContext({});
export function EuiResizableContainerContextProvider(_ref) {
  var children = _ref.children,
    registry = _ref.registry;
  return /*#__PURE__*/React.createElement(EuiResizableContainerContext.Provider, {
    value: {
      registry: registry
    }
  }, children);
}
export var useEuiResizableContainerContext = function useEuiResizableContainerContext() {
  var context = useContext(EuiResizableContainerContext);
  if (!context.registry) {
    throw new Error('useEuiResizableContainerContext must be used within a <EuiResizableContainerContextProvider />');
  }
  return context;
};