var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/dfa/LexerDFASerializer.ts
var LexerDFASerializer_exports = {};
__export(LexerDFASerializer_exports, {
  LexerDFASerializer: () => LexerDFASerializer
});
module.exports = __toCommonJS(LexerDFASerializer_exports);

// src/IntStream.ts
var IntStream;
((IntStream2) => {
  IntStream2.EOF = -1;
  IntStream2.UNKNOWN_SOURCE_NAME = "<unknown>";
})(IntStream || (IntStream = {}));

// src/Token.ts
var Token;
((Token2) => {
  Token2.INVALID_TYPE = 0;
  Token2.EPSILON = -2;
  Token2.MIN_USER_TOKEN_TYPE = 1;
  Token2.EOF = IntStream.EOF;
  Token2.DEFAULT_CHANNEL = 0;
  Token2.HIDDEN_CHANNEL = 1;
  Token2.MIN_USER_CHANNEL_VALUE = 2;
})(Token || (Token = {}));

// src/Vocabulary.ts
var Vocabulary = class _Vocabulary {
  static {
    __name(this, "Vocabulary");
  }
  static EMPTY_NAMES = [];
  /**
   * Gets an empty {@link Vocabulary} instance.
   *
   *
   * No literal or symbol names are assigned to token types, so
   * {@link #getDisplayName(int)} returns the numeric value for all tokens
   * except {@link Token#EOF}.
   */
  static EMPTY_VOCABULARY = new _Vocabulary(_Vocabulary.EMPTY_NAMES, _Vocabulary.EMPTY_NAMES, _Vocabulary.EMPTY_NAMES);
  maxTokenType;
  literalNames;
  symbolicNames;
  displayNames;
  /**
   * Constructs a new instance of {@link Vocabulary} from the specified
   * literal, symbolic, and display token names.
   *
   * @param literalNames The literal names assigned to tokens, or `null`
   * if no literal names are assigned.
   * @param symbolicNames The symbolic names assigned to tokens, or
   * `null` if no symbolic names are assigned.
   * @param displayNames The display names assigned to tokens, or `null`
   * to use the values in `literalNames` and `symbolicNames` as
   * the source of display names, as described in
   * {@link #getDisplayName(int)}.
   */
  constructor(literalNames, symbolicNames, displayNames) {
    this.literalNames = literalNames ?? _Vocabulary.EMPTY_NAMES;
    this.symbolicNames = symbolicNames ?? _Vocabulary.EMPTY_NAMES;
    this.displayNames = displayNames ?? _Vocabulary.EMPTY_NAMES;
    this.maxTokenType = Math.max(this.displayNames.length, Math.max(
      this.literalNames.length,
      this.symbolicNames.length
    )) - 1;
  }
  /**
   * Returns a {@link Vocabulary} instance from the specified set of token
   * names. This method acts as a compatibility layer for the single
   * `tokenNames` array generated by previous releases of ANTLR.
   *
   * The resulting vocabulary instance returns `null` for
   * {@link getLiteralName getLiteralName(int)} and {@link getSymbolicName getSymbolicName(int)}, and the
   * value from `tokenNames` for the display names.
   *
   * @param tokenNames The token names, or `null` if no token names are
   * available.
   * @returns A {@link Vocabulary} instance which uses `tokenNames` for
   * the display names of tokens.
   */
  static fromTokenNames(tokenNames) {
    if (tokenNames == null || tokenNames.length === 0) {
      return _Vocabulary.EMPTY_VOCABULARY;
    }
    const literalNames = [...tokenNames];
    const symbolicNames = [...tokenNames];
    for (let i = 0; i < tokenNames.length; i++) {
      const tokenName = tokenNames[i];
      if (tokenName == null) {
        continue;
      }
      if (tokenName.length > 0) {
        const firstChar = tokenName.codePointAt(0);
        if (firstChar === 39) {
          symbolicNames[i] = null;
          continue;
        } else if (firstChar >= 65 && firstChar <= 90) {
          literalNames[i] = null;
          continue;
        }
      }
      literalNames[i] = null;
      symbolicNames[i] = null;
    }
    return new _Vocabulary(literalNames, symbolicNames, tokenNames);
  }
  getMaxTokenType() {
    return this.maxTokenType;
  }
  getLiteralName(tokenType) {
    if (tokenType >= 0 && tokenType < this.literalNames.length) {
      return this.literalNames[tokenType];
    }
    return null;
  }
  getSymbolicName(tokenType) {
    if (tokenType >= 0 && tokenType < this.symbolicNames.length) {
      return this.symbolicNames[tokenType];
    }
    if (tokenType === Token.EOF) {
      return "EOF";
    }
    return null;
  }
  getDisplayName(tokenType) {
    if (tokenType >= 0 && tokenType < this.displayNames.length) {
      const displayName = this.displayNames[tokenType];
      if (displayName != null) {
        return displayName;
      }
    }
    const literalName = this.getLiteralName(tokenType);
    if (literalName != null) {
      return literalName;
    }
    const symbolicName = this.getSymbolicName(tokenType);
    if (symbolicName != null) {
      return symbolicName;
    }
    return `${tokenType}`;
  }
  getLiteralNames() {
    return this.literalNames;
  }
  getSymbolicNames() {
    return this.symbolicNames;
  }
  getDisplayNames() {
    return this.displayNames;
  }
};

// src/dfa/DFASerializer.ts
var DFASerializer = class {
  static {
    __name(this, "DFASerializer");
  }
  dfa;
  vocabulary;
  constructor(dfa, vocabulary) {
    this.dfa = dfa;
    this.vocabulary = vocabulary;
  }
  toString() {
    if (!this.dfa.s0) {
      return "";
    }
    let buf = "";
    const states = this.dfa.getStates();
    for (const s of states) {
      let n = 0;
      n = s.edges.length;
      for (let i = 0; i < n; i++) {
        const t = s.edges[i];
        if (t && t.stateNumber !== 2147483647) {
          buf += this.getStateString(s);
          const label = this.getEdgeLabel(i);
          buf += "-";
          buf += label;
          buf += "->";
          buf += this.getStateString(t);
          buf += "\n";
        }
      }
    }
    return buf;
  }
  getEdgeLabel(i) {
    const name = this.vocabulary.getDisplayName(i - 1);
    return `${name}`;
  }
  getStateString(s) {
    const n = s.stateNumber;
    const baseStateStr = (s.isAcceptState ? ":" : "") + "s" + n + (s.requiresFullContext ? "^" : "");
    if (s.isAcceptState) {
      if (s.predicates !== null) {
        return `${baseStateStr}=>${s.predicates.toString()}`;
      }
      return `${baseStateStr}=>${s.prediction}`;
    } else {
      return `${baseStateStr}`;
    }
  }
};

// src/dfa/LexerDFASerializer.ts
var LexerDFASerializer = class extends DFASerializer {
  static {
    __name(this, "LexerDFASerializer");
  }
  constructor(dfa) {
    super(dfa, Vocabulary.EMPTY_VOCABULARY);
  }
  getEdgeLabel = /* @__PURE__ */ __name((i) => {
    return "'" + String.fromCharCode(i) + "'";
  }, "getEdgeLabel");
};
