"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileProcessorService = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class FileProcessorService {
  constructor() {
    _defineProperty(this, "_fileProcessors", void 0);
    this._fileProcessors = new Map();
  }
  registerFileProcessor(fileType, fileProcessor) {
    if (this._fileProcessors.has(fileType)) {
      throw new Error(`File processor for ${fileType} already exists`);
    }
    this._fileProcessors.set(fileType, fileProcessor);
  }
  getFileProcessor(fileType) {
    return this._fileProcessors.get(fileType);
  }
  hasFileProcessorBeenRegistered(fileType) {
    return this._fileProcessors.has(fileType);
  }
}
exports.FileProcessorService = FileProcessorService;