/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.find;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.list.OWLObjectList;
import org.protege.editor.owl.ui.view.Findable;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntityFindPanel
extends JPanel {
    private OWLEditorKit owlEditorKit;
    private Findable<?> findable;
    private final JTextField textField = new AugmentedJTextField("Enter search text");
    private JList<OWLEntity> resultsList;
    Timer findTimer;

    public OWLEntityFindPanel(OWLEditorKit owlEditorKit, Findable<?> findable) {
        this.owlEditorKit = owlEditorKit;
        this.findable = findable;
        this.createUI();
        this.findTimer = new Timer(300, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFindPanel.this.doUpdate();
            }
        });
        this.findTimer.setRepeats(false);
    }

    public OWLEntity getSelectedEntity() {
        return this.resultsList.getSelectedValue();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(7, 7));
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add(this.textField);
        this.add((Component)textFieldPanel, "North");
        this.resultsList = new OWLObjectList<OWLEntity>(this.owlEditorKit);
        JPanel resultsListPanel = new JPanel(new BorderLayout());
        resultsListPanel.add(ComponentFactory.createScrollPane(this.resultsList));
        this.add((Component)resultsListPanel, "Center");
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OWLEntityFindPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OWLEntityFindPanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                OWLEntityFindPanel.this.handleKeyPressed(e);
            }
        });
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 38) {
            this.navUp();
        } else if (e.getKeyCode() == 40) {
            this.navDown();
        }
    }

    private void navUp() {
        int selIndex = this.resultsList.getSelectedIndex();
        if (selIndex == -1) {
            return;
        }
        if (--selIndex < 0) {
            selIndex = this.resultsList.getModel().getSize() - 1;
        }
        this.resultsList.setSelectedIndex(selIndex);
    }

    private void navDown() {
        int selIndex = this.resultsList.getSelectedIndex();
        if (selIndex == -1) {
            return;
        }
        if (++selIndex > this.resultsList.getModel().getSize() - 1) {
            selIndex = 0;
        }
        this.resultsList.setSelectedIndex(selIndex);
    }

    private void update() {
        this.findTimer.restart();
    }

    private void doUpdate() {
        String text = this.textField.getText().trim();
        if (text.length() == 0) {
            this.resultsList.setListData((OWLEntity[])new OWLEntity[0]);
            return;
        }
        List<?> result = this.findable.find(text);
        this.resultsList.setListData((OWLEntity[])result.toArray(new OWLEntity[result.size()]));
        if (!result.isEmpty()) {
            this.resultsList.setSelectedIndex(0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 400);
    }

    public static OWLEntity showDialog(Component parent, OWLEditorKit owlEditorKit, Findable<? extends OWLEntity> findable) {
        OWLEntityFindPanel panel = new OWLEntityFindPanel(owlEditorKit, findable);
        int ret = JOptionPaneEx.showConfirmDialog((Component)parent, (String)"Find", (JComponent)panel, (int)-1, (int)2, (JComponent)panel.textField);
        if (ret == 0) {
            return panel.getSelectedEntity();
        }
        return null;
    }
}

