/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.PerformanceCareRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0016J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RangeValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/PerformanceCareRule;", "range", "Lkotlin/ranges/IntRange;", "(Lkotlin/ranges/IntRange;)V", "getRange", "()Lkotlin/ranges/IntRange;", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "toString", "validateData", "ap-validation"})
public final class RangeValidationRule
extends PerformanceCareRule {
    @Nullable
    private final IntRange range;

    public RangeValidationRule(@Nullable IntRange range) {
        this.range = range;
    }

    @Nullable
    public final IntRange getRange() {
        return this.range;
    }

    @Override
    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        ValidationResultType validationResultType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.range == null) {
            return ValidationResultType.INCORRECT_RULE;
        }
        try {
            int value = Integer.parseInt(data);
            validationResultType = this.range.contains(value) ? ValidationResultType.ACCEPTED : ValidationResultType.REJECTED;
        }
        catch (NumberFormatException e2) {
            validationResultType = ValidationResultType.REJECTED;
        }
        return validationResultType;
    }

    @NotNull
    public final ValidationResultType validateData(@NotNull String data, @NotNull EventContext context) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.doValidate(data, context);
    }

    @NotNull
    public String toString() {
        return "RangeValidationRule: range=" + this.range;
    }
}

