/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: XeGPU.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::xegpu::AllocNbarrierOp,
::mlir::xegpu::AtomicRMWOp,
::mlir::xegpu::ConvertLayoutOp,
::mlir::xegpu::CreateDescOp,
::mlir::xegpu::CreateNdDescOp,
::mlir::xegpu::DpasOp,
::mlir::xegpu::FenceOp,
::mlir::xegpu::InitNbarrierOp,
::mlir::xegpu::LoadGatherOp,
::mlir::xegpu::LoadNdOp,
::mlir::xegpu::NbarrierArriveOp,
::mlir::xegpu::NbarrierWaitOp,
::mlir::xegpu::PrefetchNdOp,
::mlir::xegpu::PrefetchOp,
::mlir::xegpu::StoreNdOp,
::mlir::xegpu::StoreScatterOp,
::mlir::xegpu::UpdateNdOffsetOp,
::mlir::xegpu::UpdateOffsetOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace xegpu {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::xegpu::TensorDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be TensorDesc describing regions of interested data., but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (elementType.isSignlessInteger(1)); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1)))) || ((type.isSignlessInteger(1))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of 1-bit signless integer values of ranks 1 or 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))) || ((elementType.isSignedInteger(1))) || ((elementType.isSignedInteger(8))) || ((elementType.isSignedInteger(16))) || ((elementType.isSignedInteger(32))) || ((elementType.isSignedInteger(64))) || ((elementType.isUnsignedInteger(1))) || ((elementType.isUnsignedInteger(8))) || ((elementType.isUnsignedInteger(16))) || ((elementType.isUnsignedInteger(32))) || ((elementType.isUnsignedInteger(64)))) || (((elementType.isF16())) || ((elementType.isF32())) || ((elementType.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && (((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 2)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 3)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 4))))) || ((((type.isSignlessInteger(1))) || ((type.isSignlessInteger(8))) || ((type.isSignlessInteger(16))) || ((type.isSignlessInteger(32))) || ((type.isSignlessInteger(64))) || ((type.isSignedInteger(1))) || ((type.isSignedInteger(8))) || ((type.isSignedInteger(16))) || ((type.isSignedInteger(32))) || ((type.isSignedInteger(64))) || ((type.isUnsignedInteger(1))) || ((type.isUnsignedInteger(8))) || ((type.isUnsignedInteger(16))) || ((type.isUnsignedInteger(32))) || ((type.isUnsignedInteger(64)))) || (((type.isF16())) || ((type.isF32())) || ((type.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(type))) || ((::llvm::isa<::mlir::FloatTF32Type>(type))))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type values of ranks 1/2/3/4 or 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))) || ((elementType.isSignedInteger(1))) || ((elementType.isSignedInteger(8))) || ((elementType.isSignedInteger(16))) || ((elementType.isSignedInteger(32))) || ((elementType.isSignedInteger(64))) || ((elementType.isUnsignedInteger(1))) || ((elementType.isUnsignedInteger(8))) || ((elementType.isUnsignedInteger(16))) || ((elementType.isUnsignedInteger(32))) || ((elementType.isUnsignedInteger(64)))) || (((elementType.isF16())) || ((elementType.isF32())) || ((elementType.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 2))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type values of ranks 2, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((::llvm::isa<::mlir::MemRefType>(type))) && ([](::mlir::Type elementType) { return (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))) || ((elementType.isSignedInteger(1))) || ((elementType.isSignedInteger(8))) || ((elementType.isSignedInteger(16))) || ((elementType.isSignedInteger(32))) || ((elementType.isSignedInteger(64))) || ((elementType.isUnsignedInteger(1))) || ((elementType.isUnsignedInteger(8))) || ((elementType.isUnsignedInteger(16))) || ((elementType.isUnsignedInteger(32))) || ((elementType.isUnsignedInteger(64)))) || (((elementType.isF16())) || ((elementType.isF32())) || ((elementType.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && (((::llvm::cast<::mlir::ShapedType>(type).hasRank())) && ((::llvm::cast<::mlir::ShapedType>(type).getRank() >= 1)))) || ((type.isUnsignedInteger(64))) || ((type.isUnsignedInteger(32))) || ((type.isSignlessInteger(64))) || ((type.isSignlessInteger(32))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be non-0-ranked.memref of 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type values or 64-bit unsigned integer or 32-bit unsigned integer or 64-bit signless integer or 32-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU6(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (::llvm::isa<::mlir::IndexType>(elementType)); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of index values of ranks 1, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU7(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::IndexType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be variadic of index, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU8(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))) || ((elementType.isSignedInteger(1))) || ((elementType.isSignedInteger(8))) || ((elementType.isSignedInteger(16))) || ((elementType.isSignedInteger(32))) || ((elementType.isSignedInteger(64))) || ((elementType.isUnsignedInteger(1))) || ((elementType.isUnsignedInteger(8))) || ((elementType.isUnsignedInteger(16))) || ((elementType.isUnsignedInteger(32))) || ((elementType.isUnsignedInteger(64)))) || (((elementType.isF16())) || ((elementType.isF32())) || ((elementType.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && (((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 2)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 3)))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type values of ranks 1/2/3, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU9(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && ([](::mlir::Type elementType) { return (((elementType.isSignlessInteger(1))) || ((elementType.isSignlessInteger(8))) || ((elementType.isSignlessInteger(16))) || ((elementType.isSignlessInteger(32))) || ((elementType.isSignlessInteger(64))) || ((elementType.isSignedInteger(1))) || ((elementType.isSignedInteger(8))) || ((elementType.isSignedInteger(16))) || ((elementType.isSignedInteger(32))) || ((elementType.isSignedInteger(64))) || ((elementType.isUnsignedInteger(1))) || ((elementType.isUnsignedInteger(8))) || ((elementType.isUnsignedInteger(16))) || ((elementType.isUnsignedInteger(32))) || ((elementType.isUnsignedInteger(64)))) || (((elementType.isF16())) || ((elementType.isF32())) || ((elementType.isF64())) || ((::llvm::isa<::mlir::BFloat16Type>(elementType))) || ((::llvm::isa<::mlir::FloatTF32Type>(elementType)))); }(::llvm::cast<::mlir::ShapedType>(type).getElementType()))) && ((((::llvm::isa<::mlir::VectorType>(type))) && ((::llvm::cast<::mlir::VectorType>(type).getRank() > 0))) && (((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 1)) || ((::llvm::cast<::mlir::VectorType>(type).getRank()
                           == 2)))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be vector of 1-bit signless integer or 8-bit signless integer or 16-bit signless integer or 32-bit signless integer or 64-bit signless integer or 1-bit signed integer or 8-bit signed integer or 16-bit signed integer or 32-bit signed integer or 64-bit signed integer or 1-bit unsigned integer or 8-bit unsigned integer or 16-bit unsigned integer or 32-bit unsigned integer or 64-bit unsigned integer or 16-bit float or 32-bit float or 64-bit float or bfloat16 type or tf32 type values of ranks 1/2, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU10(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(8)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 8-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_XeGPU11(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::xegpu::NbarrierType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be !xegpu.nbarrier a custom XeGPU type representing a barrier., but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(64)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::arith::AtomicRMWKindAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: allowed 64-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xegpu::LayoutAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: \n    Describes the data distribution to subgroups and work-items for a tensor\n    specified by the tensor descriptor.\n  ";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: i64 dense array attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xegpu::MemorySpaceAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe the location of data described by a `TensorDesc`:\n                 Global device memory (`Global`) or Shared local memory (`SLM`).";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xegpu::FenceScopeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describes the scope of fence.\n                    \"workgroup\" means that the scope is within each work group.\n                    \"gpu\" means the scope is across work groups within the gpu.";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_XeGPU8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_XeGPU8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace xegpu
} // namespace mlir
namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::AllocNbarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AllocNbarrierOpGenericAdaptorBase::AllocNbarrierOpGenericAdaptorBase(AllocNbarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint64_t AllocNbarrierOpGenericAdaptorBase::getNbarrierNum() {
  auto attr = getNbarrierNumAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
AllocNbarrierOpAdaptor::AllocNbarrierOpAdaptor(AllocNbarrierOp op) : AllocNbarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AllocNbarrierOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_nbarrier_num = getProperties().nbarrier_num; (void)tblgen_nbarrier_num;
  if (!tblgen_nbarrier_num) return emitError(loc, "'xegpu.alloc_nbarrier' op ""requires attribute 'nbarrier_num'");

  if (tblgen_nbarrier_num && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_nbarrier_num))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_nbarrier_num).getType().isSignlessInteger(64)))))
    return emitError(loc, "'xegpu.alloc_nbarrier' op ""attribute 'nbarrier_num' failed to satisfy constraint: 64-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult AllocNbarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.nbarrier_num;
       auto attr = dict.get("nbarrier_num");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `nbarrier_num` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AllocNbarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.nbarrier_num;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("nbarrier_num",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AllocNbarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.nbarrier_num.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AllocNbarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "nbarrier_num")
      return prop.nbarrier_num;
  return std::nullopt;
}

void AllocNbarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "nbarrier_num") {
       prop.nbarrier_num = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.nbarrier_num)>>(value);
       return;
    }
}

void AllocNbarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.nbarrier_num) attrs.append("nbarrier_num", prop.nbarrier_num);
}

::llvm::LogicalResult AllocNbarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getNbarrierNumAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU1(attr, "nbarrier_num", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AllocNbarrierOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.nbarrier_num)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AllocNbarrierOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.nbarrier_num);
}

uint64_t AllocNbarrierOp::getNbarrierNum() {
  auto attr = getNbarrierNumAttr();
  return attr.getValue().getZExtValue();
}

void AllocNbarrierOp::setNbarrierNum(uint64_t attrValue) {
  getProperties().nbarrier_num = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), attrValue);
}

void AllocNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::IntegerAttr nbarrier_num) {
  odsState.getOrAddProperties<Properties>().nbarrier_num = nbarrier_num;
}

void AllocNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr nbarrier_num) {
  odsState.getOrAddProperties<Properties>().nbarrier_num = nbarrier_num;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AllocNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, uint64_t nbarrier_num) {
  odsState.getOrAddProperties<Properties>().nbarrier_num = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), nbarrier_num);
}

void AllocNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint64_t nbarrier_num) {
  odsState.getOrAddProperties<Properties>().nbarrier_num = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(64), nbarrier_num);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AllocNbarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AllocNbarrierOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void AllocNbarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult AllocNbarrierOp::verifyInvariantsImpl() {
  auto tblgen_nbarrier_num = getProperties().nbarrier_num; (void)tblgen_nbarrier_num;
  if (!tblgen_nbarrier_num) return emitOpError("requires attribute 'nbarrier_num'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU1(*this, tblgen_nbarrier_num, "nbarrier_num")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult AllocNbarrierOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult AllocNbarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::IntegerAttr nbarrier_numAttr;

  if (parser.parseCustomAttributeWithFallback(nbarrier_numAttr, parser.getBuilder().getIntegerType(64))) {
    return ::mlir::failure();
  }
  if (nbarrier_numAttr) result.getOrAddProperties<AllocNbarrierOp::Properties>().nbarrier_num = nbarrier_numAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void AllocNbarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getNbarrierNumAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("nbarrier_num");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::AllocNbarrierOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::AtomicRMWOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AtomicRMWOpGenericAdaptorBase::AtomicRMWOpGenericAdaptorBase(AtomicRMWOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::arith::AtomicRMWKind AtomicRMWOpGenericAdaptorBase::getKind() {
  auto attr = getKindAttr();
  return attr.getValue();
}

} // namespace detail
AtomicRMWOpAdaptor::AtomicRMWOpAdaptor(AtomicRMWOp op) : AtomicRMWOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult AtomicRMWOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_kind = getProperties().kind; (void)tblgen_kind;
  if (!tblgen_kind) return emitError(loc, "'xegpu.atomic_rmw' op ""requires attribute 'kind'");

  if (tblgen_kind && !((::llvm::isa<::mlir::arith::AtomicRMWKindAttr>(tblgen_kind))))
    return emitError(loc, "'xegpu.atomic_rmw' op ""attribute 'kind' failed to satisfy constraint: allowed 64-bit signless integer cases: 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14");
  return ::mlir::success();
}

::llvm::LogicalResult AtomicRMWOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.kind;
       auto attr = dict.get("kind");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `kind` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute AtomicRMWOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.kind;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("kind",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AtomicRMWOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.kind.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> AtomicRMWOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "kind")
      return prop.kind;
  return std::nullopt;
}

void AtomicRMWOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "kind") {
       prop.kind = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.kind)>>(value);
       return;
    }
}

void AtomicRMWOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.kind) attrs.append("kind", prop.kind);
}

::llvm::LogicalResult AtomicRMWOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getKindAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU2(attr, "kind", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult AtomicRMWOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.kind)))
    return ::mlir::failure();
  return ::mlir::success();
}

void AtomicRMWOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.kind);
}

::mlir::arith::AtomicRMWKind AtomicRMWOp::getKind() {
  auto attr = getKindAttr();
  return attr.getValue();
}

void AtomicRMWOp::setKind(::mlir::arith::AtomicRMWKind attrValue) {
  getProperties().kind = ::mlir::arith::AtomicRMWKindAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void AtomicRMWOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::arith::AtomicRMWKindAttr kind, ::mlir::Value tensorDesc, ::mlir::Value mask, ::mlir::Value value) {
  odsState.addOperands(tensorDesc);
  odsState.addOperands(mask);
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().kind = kind;
  odsState.addTypes(result);
}

void AtomicRMWOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::arith::AtomicRMWKindAttr kind, ::mlir::Value tensorDesc, ::mlir::Value mask, ::mlir::Value value) {
  odsState.addOperands(tensorDesc);
  odsState.addOperands(mask);
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().kind = kind;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicRMWOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::arith::AtomicRMWKind kind, ::mlir::Value tensorDesc, ::mlir::Value mask, ::mlir::Value value) {
  odsState.addOperands(tensorDesc);
  odsState.addOperands(mask);
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().kind = ::mlir::arith::AtomicRMWKindAttr::get(odsBuilder.getContext(), kind);
  odsState.addTypes(result);
}

void AtomicRMWOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::arith::AtomicRMWKind kind, ::mlir::Value tensorDesc, ::mlir::Value mask, ::mlir::Value value) {
  odsState.addOperands(tensorDesc);
  odsState.addOperands(mask);
  odsState.addOperands(value);
  odsState.getOrAddProperties<Properties>().kind = ::mlir::arith::AtomicRMWKindAttr::get(odsBuilder.getContext(), kind);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AtomicRMWOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<AtomicRMWOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void AtomicRMWOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult AtomicRMWOp::verifyInvariantsImpl() {
  auto tblgen_kind = getProperties().kind; (void)tblgen_kind;
  if (!tblgen_kind) return emitOpError("requires attribute 'kind'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU2(*this, tblgen_kind, "kind")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(2).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(2).begin()))) == (getElementTypeOrSelf((*this->getODSResults(0).begin()))) && (getElementTypeOrSelf((*this->getODSResults(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))))))
    return emitOpError("failed to verify that all of {tensorDesc, value, result} have same element type");
  if (!(((::llvm::cast<::mlir::ShapedType>((*this->getODSOperands(0).begin()).getType()).getShape()) == (::llvm::cast<::mlir::ShapedType>((*this->getODSOperands(2).begin()).getType()).getShape()) && (::llvm::cast<::mlir::ShapedType>((*this->getODSOperands(2).begin()).getType()).getShape()) == (::llvm::cast<::mlir::ShapedType>((*this->getODSResults(0).begin()).getType()).getShape()) && (::llvm::cast<::mlir::ShapedType>((*this->getODSResults(0).begin()).getType()).getShape()) == (::llvm::cast<::mlir::ShapedType>((*this->getODSOperands(0).begin()).getType()).getShape()))))
    return emitOpError("failed to verify that all of {tensorDesc, value, result} have same shape");
  return ::mlir::success();
}

::llvm::LogicalResult AtomicRMWOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult AtomicRMWOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::arith::AtomicRMWKindAttr kindAttr;
  ::mlir::OpAsmParser::UnresolvedOperand tensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> tensorDescOperands(&tensorDescRawOperand, 1);  ::llvm::SMLoc tensorDescOperandsLoc;
  (void)tensorDescOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand maskRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> maskOperands(&maskRawOperand, 1);  ::llvm::SMLoc maskOperandsLoc;
  (void)maskOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(&valueRawOperand, 1);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::Type tensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> tensorDescTypes(&tensorDescRawType, 1);
  ::mlir::Type maskRawType{};
  ::llvm::ArrayRef<::mlir::Type> maskTypes(&maskRawType, 1);
  ::mlir::Type valueRawType{};
  ::llvm::ArrayRef<::mlir::Type> valueTypes(&valueRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  {
    ::llvm::StringRef attrStr;
    ::mlir::NamedAttrList attrStorage;
    auto loc = parser.getCurrentLocation();
    if (parser.parseOptionalKeyword(&attrStr, {"addf","addi","assign","maximumf","maxs","maxu","minimumf","mins","minu","mulf","muli","ori","andi","maxnumf","minnumf"})) {
      ::mlir::StringAttr attrVal;
      ::mlir::OptionalParseResult parseResult =
        parser.parseOptionalAttribute(attrVal,
                                      parser.getBuilder().getNoneType(),
                                      "kind", attrStorage);
      if (parseResult.has_value()) {
        if (failed(*parseResult))
          return ::mlir::failure();
        attrStr = attrVal.getValue();
      } else {
        return parser.emitError(loc, "expected string or keyword containing one of the following enum values for attribute 'kind' [addf, addi, assign, maximumf, maxs, maxu, minimumf, mins, minu, mulf, muli, ori, andi, maxnumf, minnumf]");
      }
    }
    if (!attrStr.empty()) {
      auto attrOptional = ::mlir::arith::symbolizeAtomicRMWKind(attrStr);
      if (!attrOptional)
        return parser.emitError(loc, "invalid ")
               << "kind attribute specification: \"" << attrStr << '"';;

      kindAttr = ::mlir::arith::AtomicRMWKindAttr::get(parser.getBuilder().getContext(), *attrOptional);
        result.getOrAddProperties<AtomicRMWOp::Properties>().kind = kindAttr;
    }
  }

  tensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(tensorDescRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  maskOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(maskRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(tensorDescRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    maskRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resultRawType = type;
  }
  result.addTypes(resultTypes);
  if (parser.resolveOperands(tensorDescOperands, tensorDescTypes, tensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(maskOperands, maskTypes, maskOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AtomicRMWOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';

  {
    auto caseValue = getKind();
    auto caseValueStr = stringifyAtomicRMWKind(caseValue);
    _odsPrinter << caseValueStr;
  }
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMask();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getValue();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("kind");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getMask().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getResult().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void AtomicRMWOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::AtomicRMWOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::ConvertLayoutOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ConvertLayoutOpGenericAdaptorBase::ConvertLayoutOpGenericAdaptorBase(ConvertLayoutOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::xegpu::LayoutAttr ConvertLayoutOpGenericAdaptorBase::getSrcMap() {
  auto attr = getSrcMapAttr();
  return ::llvm::cast<::mlir::xegpu::LayoutAttr>(attr);
}

::mlir::xegpu::LayoutAttr ConvertLayoutOpGenericAdaptorBase::getResMap() {
  auto attr = getResMapAttr();
  return ::llvm::cast<::mlir::xegpu::LayoutAttr>(attr);
}

} // namespace detail
ConvertLayoutOpAdaptor::ConvertLayoutOpAdaptor(ConvertLayoutOp op) : ConvertLayoutOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ConvertLayoutOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_resMap = getProperties().resMap; (void)tblgen_resMap;
  if (!tblgen_resMap) return emitError(loc, "'xegpu.convert_layout' op ""requires attribute 'resMap'");
  auto tblgen_srcMap = getProperties().srcMap; (void)tblgen_srcMap;
  if (!tblgen_srcMap) return emitError(loc, "'xegpu.convert_layout' op ""requires attribute 'srcMap'");

  if (tblgen_srcMap && !((::llvm::isa<::mlir::xegpu::LayoutAttr>(tblgen_srcMap))))
    return emitError(loc, "'xegpu.convert_layout' op ""attribute 'srcMap' failed to satisfy constraint: \n    Describes the data distribution to subgroups and work-items for a tensor\n    specified by the tensor descriptor.\n  ");

  if (tblgen_resMap && !((::llvm::isa<::mlir::xegpu::LayoutAttr>(tblgen_resMap))))
    return emitError(loc, "'xegpu.convert_layout' op ""attribute 'resMap' failed to satisfy constraint: \n    Describes the data distribution to subgroups and work-items for a tensor\n    specified by the tensor descriptor.\n  ");
  return ::mlir::success();
}

::llvm::LogicalResult ConvertLayoutOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.resMap;
       auto attr = dict.get("resMap");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `resMap` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.srcMap;
       auto attr = dict.get("srcMap");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `srcMap` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ConvertLayoutOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.resMap;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("resMap",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.srcMap;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("srcMap",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ConvertLayoutOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.resMap.getAsOpaquePointer()), 
    llvm::hash_value(prop.srcMap.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ConvertLayoutOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "resMap")
      return prop.resMap;

    if (name == "srcMap")
      return prop.srcMap;
  return std::nullopt;
}

void ConvertLayoutOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "resMap") {
       prop.resMap = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.resMap)>>(value);
       return;
    }

    if (name == "srcMap") {
       prop.srcMap = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.srcMap)>>(value);
       return;
    }
}

void ConvertLayoutOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.resMap) attrs.append("resMap", prop.resMap);

    if (prop.srcMap) attrs.append("srcMap", prop.srcMap);
}

::llvm::LogicalResult ConvertLayoutOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getResMapAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU3(attr, "resMap", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSrcMapAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU3(attr, "srcMap", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ConvertLayoutOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.resMap)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.srcMap)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ConvertLayoutOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.resMap);
  writer.writeAttribute(prop.srcMap);
}

::mlir::xegpu::LayoutAttr ConvertLayoutOp::getSrcMap() {
  auto attr = getSrcMapAttr();
  return ::llvm::cast<::mlir::xegpu::LayoutAttr>(attr);
}

::mlir::xegpu::LayoutAttr ConvertLayoutOp::getResMap() {
  auto attr = getResMapAttr();
  return ::llvm::cast<::mlir::xegpu::LayoutAttr>(attr);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, ::mlir::xegpu::LayoutAttr srcMap, ::mlir::xegpu::LayoutAttr resMap) {
  odsState.addOperands(source);
  odsState.getOrAddProperties<Properties>().srcMap = srcMap;
  odsState.getOrAddProperties<Properties>().resMap = resMap;
  odsState.addTypes(result);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::xegpu::LayoutAttr srcMap, ::mlir::xegpu::LayoutAttr resMap) {
  odsState.addOperands(source);
  odsState.getOrAddProperties<Properties>().srcMap = srcMap;
  odsState.getOrAddProperties<Properties>().resMap = resMap;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ConvertLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ConvertLayoutOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void ConvertLayoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult ConvertLayoutOp::verifyInvariantsImpl() {
  auto tblgen_resMap = getProperties().resMap; (void)tblgen_resMap;
  if (!tblgen_resMap) return emitOpError("requires attribute 'resMap'");
  auto tblgen_srcMap = getProperties().srcMap; (void)tblgen_srcMap;
  if (!tblgen_srcMap) return emitOpError("requires attribute 'srcMap'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU3(*this, tblgen_srcMap, "srcMap")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU3(*this, tblgen_resMap, "resMap")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU4(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()) && ((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {source, result} have same type");
  return ::mlir::success();
}

::llvm::LogicalResult ConvertLayoutOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ConvertLayoutOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand sourceRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> sourceOperands(&sourceRawOperand, 1);  ::llvm::SMLoc sourceOperandsLoc;
  (void)sourceOperandsLoc;
  ::mlir::Type sourceRawType{};
  ::llvm::ArrayRef<::mlir::Type> sourceTypes(&sourceRawType, 1);

  sourceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(sourceRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    sourceRawType = type;
  }
  result.addTypes(sourceTypes[0]);
  if (parser.resolveOperands(sourceOperands, sourceTypes, sourceOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ConvertLayoutOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSource();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getSource().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ConvertLayoutOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::ConvertLayoutOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::CreateDescOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CreateDescOpGenericAdaptorBase::CreateDescOpGenericAdaptorBase(CreateDescOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
CreateDescOpAdaptor::CreateDescOpAdaptor(CreateDescOp op) : CreateDescOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult CreateDescOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult CreateDescOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute CreateDescOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CreateDescOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> CreateDescOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void CreateDescOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void CreateDescOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult CreateDescOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void CreateDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type TensorDesc, ::mlir::Value source, ::mlir::Value offsets) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  odsState.addTypes(TensorDesc);
}

void CreateDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value offsets) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CreateDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CreateDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult CreateDescOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult CreateDescOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CreateDescOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand sourceRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> sourceOperands(&sourceRawOperand, 1);  ::llvm::SMLoc sourceOperandsLoc;
  (void)sourceOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand offsetsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> offsetsOperands(&offsetsRawOperand, 1);  ::llvm::SMLoc offsetsOperandsLoc;
  (void)offsetsOperandsLoc;
  ::mlir::Type sourceRawType{};
  ::llvm::ArrayRef<::mlir::Type> sourceTypes(&sourceRawType, 1);
  ::mlir::Type offsetsRawType{};
  ::llvm::ArrayRef<::mlir::Type> offsetsTypes(&offsetsRawType, 1);
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);

  sourceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(sourceRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  offsetsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(offsetsRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    sourceRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    offsetsRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  result.addTypes(TensorDescTypes);
  if (parser.resolveOperands(sourceOperands, sourceTypes, sourceOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(offsetsOperands, offsetsTypes, offsetsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CreateDescOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSource();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getOffsets();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getSource().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getOffsets().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
}

void CreateDescOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::CreateDescOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::CreateNdDescOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CreateNdDescOpGenericAdaptorBase::CreateNdDescOpGenericAdaptorBase(CreateNdDescOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> CreateNdDescOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::llvm::ArrayRef<int64_t> CreateNdDescOpGenericAdaptorBase::getConstOffsets() {
  auto attr = getConstOffsetsAttr();
  return attr;
}

::std::optional<::llvm::ArrayRef<int64_t>> CreateNdDescOpGenericAdaptorBase::getConstShape() {
  auto attr = getConstShapeAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

::std::optional<::llvm::ArrayRef<int64_t>> CreateNdDescOpGenericAdaptorBase::getConstStrides() {
  auto attr = getConstStridesAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

} // namespace detail
CreateNdDescOpAdaptor::CreateNdDescOpAdaptor(CreateNdDescOp op) : CreateNdDescOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult CreateNdDescOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_const_offsets = getProperties().const_offsets; (void)tblgen_const_offsets;
  if (!tblgen_const_offsets) return emitError(loc, "'xegpu.create_nd_tdesc' op ""requires attribute 'const_offsets'");
  auto tblgen_const_shape = getProperties().const_shape; (void)tblgen_const_shape;
  auto tblgen_const_strides = getProperties().const_strides; (void)tblgen_const_strides;

  if (tblgen_const_offsets && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_const_offsets))))
    return emitError(loc, "'xegpu.create_nd_tdesc' op ""attribute 'const_offsets' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_const_shape && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_const_shape))))
    return emitError(loc, "'xegpu.create_nd_tdesc' op ""attribute 'const_shape' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_const_strides && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_const_strides))))
    return emitError(loc, "'xegpu.create_nd_tdesc' op ""attribute 'const_strides' failed to satisfy constraint: i64 dense array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CreateNdDescOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::MutableOperandRange CreateNdDescOp::getOffsetsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CreateNdDescOp::getShapeMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CreateNdDescOp::getStridesMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::llvm::LogicalResult CreateNdDescOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.const_offsets;
       auto attr = dict.get("const_offsets");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `const_offsets` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.const_shape;
       auto attr = dict.get("const_shape");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `const_shape` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.const_strides;
       auto attr = dict.get("const_strides");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `const_strides` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
{

      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
               ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) -> ::mlir::LogicalResult {
        return convertFromAttribute(propStorage, propAttr, emitError);
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
;
      if (attr && ::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, emitError)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::Attribute CreateNdDescOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.const_offsets;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("const_offsets",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.const_shape;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("const_shape",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.const_strides;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("const_strides",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      auto attr = [&]() -> ::mlir::Attribute {
        return ::mlir::DenseI32ArrayAttr::get(ctx, propStorage);
      }();
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes", attr));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CreateNdDescOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    using ::llvm::hash_value;
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.const_offsets.getAsOpaquePointer()), 
    llvm::hash_value(prop.const_shape.getAsOpaquePointer()), 
    llvm::hash_value(prop.const_strides.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> CreateNdDescOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "const_offsets")
      return prop.const_offsets;

    if (name == "const_shape")
      return prop.const_shape;

    if (name == "const_strides")
      return prop.const_strides;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }();
  return std::nullopt;
}

void CreateNdDescOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "const_offsets") {
       prop.const_offsets = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.const_offsets)>>(value);
       return;
    }

    if (name == "const_shape") {
       prop.const_shape = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.const_shape)>>(value);
       return;
    }

    if (name == "const_strides") {
       prop.const_strides = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.const_strides)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void CreateNdDescOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.const_offsets) attrs.append("const_offsets", prop.const_offsets);

    if (prop.const_shape) attrs.append("const_shape", prop.const_shape);

    if (prop.const_strides) attrs.append("const_strides", prop.const_strides);
  attrs.append("operandSegmentSizes", [&]() -> ::mlir::Attribute { return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes); }());
}

::llvm::LogicalResult CreateNdDescOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getConstOffsetsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(attr, "const_offsets", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getConstShapeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(attr, "const_shape", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getConstStridesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(attr, "const_strides", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult CreateNdDescOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.const_offsets)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.const_shape)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.const_strides)))
    return ::mlir::failure();

  if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
    auto &propStorage = prop.operandSegmentSizes;
    ::mlir::DenseI32ArrayAttr attr;
    if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
    if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
      reader.emitError("size mismatch for operand/result_segment_size");
      return ::mlir::failure();
    }
    ::llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
  }

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

  if (reader.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void CreateNdDescOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.const_offsets);

  writer.writeOptionalAttribute(prop.const_shape);

  writer.writeOptionalAttribute(prop.const_strides);

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  auto &propStorage = prop.operandSegmentSizes;
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(this->getContext(), propStorage));
}

  {
    auto &propStorage = prop.operandSegmentSizes;

  if (writer.getBytecodeVersion() >= /*kNativePropertiesODSSegmentSize=*/6)
    writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::llvm::ArrayRef<int64_t> CreateNdDescOp::getConstOffsets() {
  auto attr = getConstOffsetsAttr();
  return attr;
}

::std::optional<::llvm::ArrayRef<int64_t>> CreateNdDescOp::getConstShape() {
  auto attr = getConstShapeAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

::std::optional<::llvm::ArrayRef<int64_t>> CreateNdDescOp::getConstStrides() {
  auto attr = getConstStridesAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

void CreateNdDescOp::setConstOffsets(::llvm::ArrayRef<int64_t> attrValue) {
  getProperties().const_offsets = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(attrValue);
}

void CreateNdDescOp::setConstShape(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().const_shape;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void CreateNdDescOp::setConstStrides(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().const_strides;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void CreateNdDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type TensorDesc, ::mlir::Value source, ::mlir::ValueRange offsets, ::mlir::ValueRange shape, ::mlir::ValueRange strides, ::mlir::DenseI64ArrayAttr const_offsets, /*optional*/::mlir::DenseI64ArrayAttr const_shape, /*optional*/::mlir::DenseI64ArrayAttr const_strides) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  odsState.addOperands(shape);
  odsState.addOperands(strides);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(offsets.size()), static_cast<int32_t>(shape.size()), static_cast<int32_t>(strides.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().const_offsets = const_offsets;
  if (const_shape) {
    odsState.getOrAddProperties<Properties>().const_shape = const_shape;
  }
  if (const_strides) {
    odsState.getOrAddProperties<Properties>().const_strides = const_strides;
  }
  odsState.addTypes(TensorDesc);
}

void CreateNdDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange offsets, ::mlir::ValueRange shape, ::mlir::ValueRange strides, ::mlir::DenseI64ArrayAttr const_offsets, /*optional*/::mlir::DenseI64ArrayAttr const_shape, /*optional*/::mlir::DenseI64ArrayAttr const_strides) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  odsState.addOperands(shape);
  odsState.addOperands(strides);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(offsets.size()), static_cast<int32_t>(shape.size()), static_cast<int32_t>(strides.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().const_offsets = const_offsets;
  if (const_shape) {
    odsState.getOrAddProperties<Properties>().const_shape = const_shape;
  }
  if (const_strides) {
    odsState.getOrAddProperties<Properties>().const_strides = const_strides;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CreateNdDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type TensorDesc, ::mlir::Value source, ::mlir::ValueRange offsets, ::mlir::ValueRange shape, ::mlir::ValueRange strides, ::llvm::ArrayRef<int64_t> const_offsets, /*optional*/::mlir::DenseI64ArrayAttr const_shape, /*optional*/::mlir::DenseI64ArrayAttr const_strides) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  odsState.addOperands(shape);
  odsState.addOperands(strides);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(offsets.size()), static_cast<int32_t>(shape.size()), static_cast<int32_t>(strides.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().const_offsets = odsBuilder.getDenseI64ArrayAttr(const_offsets);
  if (const_shape) {
    odsState.getOrAddProperties<Properties>().const_shape = const_shape;
  }
  if (const_strides) {
    odsState.getOrAddProperties<Properties>().const_strides = const_strides;
  }
  odsState.addTypes(TensorDesc);
}

void CreateNdDescOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange offsets, ::mlir::ValueRange shape, ::mlir::ValueRange strides, ::llvm::ArrayRef<int64_t> const_offsets, /*optional*/::mlir::DenseI64ArrayAttr const_shape, /*optional*/::mlir::DenseI64ArrayAttr const_strides) {
  odsState.addOperands(source);
  odsState.addOperands(offsets);
  odsState.addOperands(shape);
  odsState.addOperands(strides);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(offsets.size()), static_cast<int32_t>(shape.size()), static_cast<int32_t>(strides.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().const_offsets = odsBuilder.getDenseI64ArrayAttr(const_offsets);
  if (const_shape) {
    odsState.getOrAddProperties<Properties>().const_shape = const_shape;
  }
  if (const_strides) {
    odsState.getOrAddProperties<Properties>().const_strides = const_strides;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CreateNdDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<CreateNdDescOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void CreateNdDescOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult CreateNdDescOp::verifyInvariantsImpl() {
  auto tblgen_const_offsets = getProperties().const_offsets; (void)tblgen_const_offsets;
  if (!tblgen_const_offsets) return emitOpError("requires attribute 'const_offsets'");
  auto tblgen_const_shape = getProperties().const_shape; (void)tblgen_const_shape;
  auto tblgen_const_strides = getProperties().const_strides; (void)tblgen_const_strides;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(*this, tblgen_const_offsets, "const_offsets")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(*this, tblgen_const_shape, "const_shape")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(*this, tblgen_const_strides, "const_strides")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult CreateNdDescOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CreateNdDescOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand sourceRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> sourceOperands(&sourceRawOperand, 1);  ::llvm::SMLoc sourceOperandsLoc;
  (void)sourceOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> offsetsOperands;
  ::llvm::SMLoc offsetsOperandsLoc;
  (void)offsetsOperandsLoc;
  ::mlir::DenseI64ArrayAttr const_offsetsAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> shapeOperands;
  ::llvm::SMLoc shapeOperandsLoc;
  (void)shapeOperandsLoc;
  ::mlir::DenseI64ArrayAttr const_shapeAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> stridesOperands;
  ::llvm::SMLoc stridesOperandsLoc;
  (void)stridesOperandsLoc;
  ::mlir::DenseI64ArrayAttr const_stridesAttr;
  ::mlir::Type sourceRawType{};
  ::llvm::ArrayRef<::mlir::Type> sourceTypes(&sourceRawType, 1);
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);

  sourceOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(sourceRawOperand))
    return ::mlir::failure();
  {
    offsetsOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, offsetsOperands, const_offsetsAttr);
    if (odsResult) return ::mlir::failure();
    result.getOrAddProperties<CreateNdDescOp::Properties>().const_offsets = const_offsetsAttr;
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {
  {
    shapeOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, shapeOperands, const_shapeAttr);
    if (odsResult) return ::mlir::failure();
    if (const_shapeAttr)
      result.getOrAddProperties<CreateNdDescOp::Properties>().const_shape = const_shapeAttr;
  }
  if (parser.parseComma())
    return ::mlir::failure();
  {
    stridesOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, stridesOperands, const_stridesAttr);
    if (odsResult) return ::mlir::failure();
    if (const_stridesAttr)
      result.getOrAddProperties<CreateNdDescOp::Properties>().const_strides = const_stridesAttr;
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    sourceRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(offsetsOperands.size()), static_cast<int32_t>(shapeOperands.size()), static_cast<int32_t>(stridesOperands.size())}), result.getOrAddProperties<CreateNdDescOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIndexType();
  result.addTypes(TensorDescTypes);
  if (parser.resolveOperands(sourceOperands, sourceTypes, sourceOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(offsetsOperands, odsBuildableType0, offsetsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(shapeOperands, odsBuildableType0, shapeOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(stridesOperands, odsBuildableType0, stridesOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CreateNdDescOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSource();
  printDynamicIndexList(_odsPrinter, *this, getOffsets(), getConstOffsetsAttr());
  if (((!getShape().empty()) || (getConstShapeAttr()))) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getShape(), getConstShapeAttr());
    _odsPrinter << ",";
    _odsPrinter << ' ';
    printDynamicIndexList(_odsPrinter, *this, getStrides(), getConstStridesAttr());
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("const_offsets");
  elidedAttrs.push_back("const_shape");
  elidedAttrs.push_back("const_strides");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getSource().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
}

void CreateNdDescOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::CreateNdDescOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::DpasOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DpasOpGenericAdaptorBase::DpasOpGenericAdaptorBase(DpasOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> DpasOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

} // namespace detail
DpasOpAdaptor::DpasOpAdaptor(DpasOp op) : DpasOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult DpasOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DpasOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 2) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange DpasOp::getAccMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult DpasOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute DpasOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DpasOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> DpasOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void DpasOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void DpasOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult DpasOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void DpasOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::Value acc) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  if (acc)
    odsState.addOperands(acc);
  odsState.addTypes(result);
}

void DpasOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value lhs, ::mlir::Value rhs, /*optional*/::mlir::Value acc) {
  odsState.addOperands(lhs);
  odsState.addOperands(rhs);
  if (acc)
    odsState.addOperands(acc);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DpasOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DpasOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult DpasOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU8(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU9(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU9(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))))))
    return emitOpError("failed to verify that all of {lhs, rhs} have same element type");
  return ::mlir::success();
}

::llvm::LogicalResult DpasOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DpasOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand lhsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> lhsOperands(&lhsRawOperand, 1);  ::llvm::SMLoc lhsOperandsLoc;
  (void)lhsOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand rhsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> rhsOperands(&rhsRawOperand, 1);  ::llvm::SMLoc rhsOperandsLoc;
  (void)rhsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> accOperands;
  ::llvm::SMLoc accOperandsLoc;
  (void)accOperandsLoc;
  ::mlir::Type lhsRawType{};
  ::llvm::ArrayRef<::mlir::Type> lhsTypes(&lhsRawType, 1);
  ::mlir::Type rhsRawType{};
  ::llvm::ArrayRef<::mlir::Type> rhsTypes(&rhsRawType, 1);
  ::llvm::SmallVector<::mlir::Type, 1> accTypes;
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  lhsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(lhsRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  rhsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(rhsRawOperand))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    accOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      accOperands.push_back(operand);
    }
  }
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    lhsRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    rhsRawType = type;
  }
  if (::mlir::succeeded(parser.parseOptionalComma())) {

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      accTypes.push_back(optionalType);
    }
  }
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    resultRawType = type;
  }
  result.addTypes(resultTypes);
  if (parser.resolveOperands(lhsOperands, lhsTypes, lhsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(rhsOperands, rhsTypes, rhsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(accOperands, accTypes, accOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DpasOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getLhs();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getRhs();
  if (getAcc()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    if (::mlir::Value value = getAcc())
      _odsPrinter << value;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getLhs().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getRhs().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  if (getAcc()) {
    _odsPrinter << ",";
    _odsPrinter << ' ';
    _odsPrinter << (getAcc() ? ::llvm::ArrayRef<::mlir::Type>(getAcc().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getResult().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void DpasOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::DpasOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::FenceOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FenceOpGenericAdaptorBase::FenceOpGenericAdaptorBase(FenceOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::xegpu::MemorySpace FenceOpGenericAdaptorBase::getMemoryKind() {
  auto attr = getMemoryKindAttr();
  return attr.getValue();
}

::mlir::xegpu::FenceScope FenceOpGenericAdaptorBase::getFenceScope() {
  auto attr = getFenceScopeAttr();
  return attr.getValue();
}

} // namespace detail
FenceOpAdaptor::FenceOpAdaptor(FenceOp op) : FenceOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult FenceOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_fence_scope = getProperties().fence_scope; (void)tblgen_fence_scope;
  if (!tblgen_fence_scope) return emitError(loc, "'xegpu.fence' op ""requires attribute 'fence_scope'");
  auto tblgen_memory_kind = getProperties().memory_kind; (void)tblgen_memory_kind;
  if (!tblgen_memory_kind) return emitError(loc, "'xegpu.fence' op ""requires attribute 'memory_kind'");

  if (tblgen_memory_kind && !((::llvm::isa<::mlir::xegpu::MemorySpaceAttr>(tblgen_memory_kind))))
    return emitError(loc, "'xegpu.fence' op ""attribute 'memory_kind' failed to satisfy constraint: Describe the location of data described by a `TensorDesc`:\n                 Global device memory (`Global`) or Shared local memory (`SLM`).");

  if (tblgen_fence_scope && !((::llvm::isa<::mlir::xegpu::FenceScopeAttr>(tblgen_fence_scope))))
    return emitError(loc, "'xegpu.fence' op ""attribute 'fence_scope' failed to satisfy constraint: Describes the scope of fence.\n                    \"workgroup\" means that the scope is within each work group.\n                    \"gpu\" means the scope is across work groups within the gpu.");
  return ::mlir::success();
}

::llvm::LogicalResult FenceOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.fence_scope;
       auto attr = dict.get("fence_scope");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `fence_scope` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.memory_kind;
       auto attr = dict.get("memory_kind");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `memory_kind` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FenceOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.fence_scope;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("fence_scope",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.memory_kind;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("memory_kind",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FenceOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.fence_scope.getAsOpaquePointer()), 
    llvm::hash_value(prop.memory_kind.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FenceOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "fence_scope")
      return prop.fence_scope;

    if (name == "memory_kind")
      return prop.memory_kind;
  return std::nullopt;
}

void FenceOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "fence_scope") {
       prop.fence_scope = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.fence_scope)>>(value);
       return;
    }

    if (name == "memory_kind") {
       prop.memory_kind = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.memory_kind)>>(value);
       return;
    }
}

void FenceOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.fence_scope) attrs.append("fence_scope", prop.fence_scope);

    if (prop.memory_kind) attrs.append("memory_kind", prop.memory_kind);
}

::llvm::LogicalResult FenceOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getFenceScopeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU6(attr, "fence_scope", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getMemoryKindAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU5(attr, "memory_kind", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult FenceOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.fence_scope)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.memory_kind)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FenceOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.fence_scope);
  writer.writeAttribute(prop.memory_kind);
}

::mlir::xegpu::MemorySpace FenceOp::getMemoryKind() {
  auto attr = getMemoryKindAttr();
  return attr.getValue();
}

::mlir::xegpu::FenceScope FenceOp::getFenceScope() {
  auto attr = getFenceScopeAttr();
  return attr.getValue();
}

void FenceOp::setMemoryKind(::mlir::xegpu::MemorySpace attrValue) {
  getProperties().memory_kind = ::mlir::xegpu::MemorySpaceAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void FenceOp::setFenceScope(::mlir::xegpu::FenceScope attrValue) {
  getProperties().fence_scope = ::mlir::xegpu::FenceScopeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void FenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::xegpu::MemorySpaceAttr memory_kind, ::mlir::xegpu::FenceScopeAttr fence_scope) {
  odsState.getOrAddProperties<Properties>().memory_kind = memory_kind;
  odsState.getOrAddProperties<Properties>().fence_scope = fence_scope;
}

void FenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::xegpu::MemorySpaceAttr memory_kind, ::mlir::xegpu::FenceScopeAttr fence_scope) {
  odsState.getOrAddProperties<Properties>().memory_kind = memory_kind;
  odsState.getOrAddProperties<Properties>().fence_scope = fence_scope;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::xegpu::MemorySpace memory_kind, ::mlir::xegpu::FenceScope fence_scope) {
  odsState.getOrAddProperties<Properties>().memory_kind = ::mlir::xegpu::MemorySpaceAttr::get(odsBuilder.getContext(), memory_kind);
  odsState.getOrAddProperties<Properties>().fence_scope = ::mlir::xegpu::FenceScopeAttr::get(odsBuilder.getContext(), fence_scope);
}

void FenceOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::xegpu::MemorySpace memory_kind, ::mlir::xegpu::FenceScope fence_scope) {
  odsState.getOrAddProperties<Properties>().memory_kind = ::mlir::xegpu::MemorySpaceAttr::get(odsBuilder.getContext(), memory_kind);
  odsState.getOrAddProperties<Properties>().fence_scope = ::mlir::xegpu::FenceScopeAttr::get(odsBuilder.getContext(), fence_scope);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FenceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<FenceOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void FenceOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult FenceOp::verifyInvariantsImpl() {
  auto tblgen_fence_scope = getProperties().fence_scope; (void)tblgen_fence_scope;
  if (!tblgen_fence_scope) return emitOpError("requires attribute 'fence_scope'");
  auto tblgen_memory_kind = getProperties().memory_kind; (void)tblgen_memory_kind;
  if (!tblgen_memory_kind) return emitOpError("requires attribute 'memory_kind'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU5(*this, tblgen_memory_kind, "memory_kind")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU6(*this, tblgen_fence_scope, "fence_scope")))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult FenceOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult FenceOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::xegpu::MemorySpaceAttr memory_kindAttr;
  ::mlir::xegpu::FenceScopeAttr fence_scopeAttr;
  if (parser.parseKeyword("memory_kind"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(memory_kindAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (memory_kindAttr) result.getOrAddProperties<FenceOp::Properties>().memory_kind = memory_kindAttr;
  if (parser.parseComma())
    return ::mlir::failure();
  if (parser.parseKeyword("fence_scope"))
    return ::mlir::failure();
  if (parser.parseEqual())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(fence_scopeAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (fence_scopeAttr) result.getOrAddProperties<FenceOp::Properties>().fence_scope = fence_scopeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void FenceOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "memory_kind";
  _odsPrinter << ' ' << "=";
_odsPrinter.printStrippedAttrOrType(getMemoryKindAttr());
  _odsPrinter << ",";
  _odsPrinter << ' ' << "fence_scope";
  _odsPrinter << ' ' << "=";
_odsPrinter.printStrippedAttrOrType(getFenceScopeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("memory_kind");
  elidedAttrs.push_back("fence_scope");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::FenceOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::InitNbarrierOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
InitNbarrierOpGenericAdaptorBase::InitNbarrierOpGenericAdaptorBase(InitNbarrierOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
InitNbarrierOpAdaptor::InitNbarrierOpAdaptor(InitNbarrierOp op) : InitNbarrierOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult InitNbarrierOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult InitNbarrierOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute InitNbarrierOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InitNbarrierOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> InitNbarrierOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void InitNbarrierOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void InitNbarrierOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult InitNbarrierOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void InitNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value nbarrier_id, ::mlir::Value participant_thread_num) {
  odsState.addOperands(nbarrier_id);
  odsState.addOperands(participant_thread_num);
  odsState.addTypes(result);
}

void InitNbarrierOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value nbarrier_id, ::mlir::Value participant_thread_num) {
  odsState.addOperands(nbarrier_id);
  odsState.addOperands(participant_thread_num);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void InitNbarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void InitNbarrierOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult InitNbarrierOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU10(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU11(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult InitNbarrierOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult InitNbarrierOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand nbarrier_idRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> nbarrier_idOperands(&nbarrier_idRawOperand, 1);  ::llvm::SMLoc nbarrier_idOperandsLoc;
  (void)nbarrier_idOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand participant_thread_numRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> participant_thread_numOperands(&participant_thread_numRawOperand, 1);  ::llvm::SMLoc participant_thread_numOperandsLoc;
  (void)participant_thread_numOperandsLoc;
  ::mlir::Type nbarrier_idRawType{};
  ::llvm::ArrayRef<::mlir::Type> nbarrier_idTypes(&nbarrier_idRawType, 1);
  ::mlir::Type participant_thread_numRawType{};
  ::llvm::ArrayRef<::mlir::Type> participant_thread_numTypes(&participant_thread_numRawType, 1);
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  nbarrier_idOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(nbarrier_idRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  participant_thread_numOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(participant_thread_numRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    nbarrier_idRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::IntegerType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    participant_thread_numRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(nbarrier_idOperands, nbarrier_idTypes, nbarrier_idOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(participant_thread_numOperands, participant_thread_numTypes, participant_thread_numOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InitNbarrierOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getNbarrierId();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getParticipantThreadNum();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getNbarrierId().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getParticipantThreadNum().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::IntegerType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::InitNbarrierOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::LoadGatherOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LoadGatherOpGenericAdaptorBase::LoadGatherOpGenericAdaptorBase(LoadGatherOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
LoadGatherOpAdaptor::LoadGatherOpAdaptor(LoadGatherOp op) : LoadGatherOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult LoadGatherOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.load' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.load' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.load' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult LoadGatherOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LoadGatherOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LoadGatherOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LoadGatherOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;
  return std::nullopt;
}

void LoadGatherOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }
}

void LoadGatherOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);
}

::llvm::LogicalResult LoadGatherOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult LoadGatherOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LoadGatherOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadGatherOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void LoadGatherOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadGatherOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadGatherOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadGatherOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value TensorDesc, ::mlir::Value mask, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(mask);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  odsState.addTypes(value);
}

void LoadGatherOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, ::mlir::Value mask, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(mask);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LoadGatherOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<LoadGatherOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void LoadGatherOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult LoadGatherOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSResults(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSResults(0).begin()))))))
    return emitOpError("failed to verify that all of {value, TensorDesc} have same element type");
  return ::mlir::success();
}

::llvm::LogicalResult LoadGatherOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult LoadGatherOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand maskRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> maskOperands(&maskRawOperand, 1);  ::llvm::SMLoc maskOperandsLoc;
  (void)maskOperandsLoc;
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);
  ::mlir::Type maskRawType{};
  ::llvm::ArrayRef<::mlir::Type> maskTypes(&maskRawType, 1);
  ::mlir::Type valueRawType{};
  ::llvm::ArrayRef<::mlir::Type> valueTypes(&valueRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  maskOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(maskRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    maskRawType = type;
  }
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawType = type;
  }
  result.addTypes(valueTypes);
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(maskOperands, maskTypes, maskOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult LoadGatherOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void LoadGatherOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMask();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getMask().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void LoadGatherOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::LoadGatherOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::LoadNdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LoadNdOpGenericAdaptorBase::LoadNdOpGenericAdaptorBase(LoadNdOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<bool> LoadNdOpGenericAdaptorBase::getPacked() {
  auto attr = getPackedAttr();
  return attr ? ::std::optional<bool>(attr != nullptr) : (::std::nullopt);
}

::std::optional<::llvm::ArrayRef<int64_t>> LoadNdOpGenericAdaptorBase::getTranspose() {
  auto attr = getTransposeAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
LoadNdOpAdaptor::LoadNdOpAdaptor(LoadNdOp op) : LoadNdOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult LoadNdOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;
  auto tblgen_packed = getProperties().packed; (void)tblgen_packed;
  auto tblgen_transpose = getProperties().transpose; (void)tblgen_transpose;

  if (tblgen_packed && !((::llvm::isa<::mlir::UnitAttr>(tblgen_packed))))
    return emitError(loc, "'xegpu.load_nd' op ""attribute 'packed' failed to satisfy constraint: unit attribute");

  if (tblgen_transpose && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_transpose))))
    return emitError(loc, "'xegpu.load_nd' op ""attribute 'transpose' failed to satisfy constraint: i64 dense array attribute");

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.load_nd' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.load_nd' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.load_nd' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult LoadNdOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.packed;
       auto attr = dict.get("packed");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `packed` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.transpose;
       auto attr = dict.get("transpose");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `transpose` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute LoadNdOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.packed;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("packed",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.transpose;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("transpose",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LoadNdOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.packed.getAsOpaquePointer()), 
    llvm::hash_value(prop.transpose.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> LoadNdOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;

    if (name == "packed")
      return prop.packed;

    if (name == "transpose")
      return prop.transpose;
  return std::nullopt;
}

void LoadNdOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }

    if (name == "packed") {
       prop.packed = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.packed)>>(value);
       return;
    }

    if (name == "transpose") {
       prop.transpose = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.transpose)>>(value);
       return;
    }
}

void LoadNdOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);

    if (prop.packed) attrs.append("packed", prop.packed);

    if (prop.transpose) attrs.append("transpose", prop.transpose);
}

::llvm::LogicalResult LoadNdOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPackedAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU8(attr, "packed", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTransposeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(attr, "transpose", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult LoadNdOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.packed)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.transpose)))
    return ::mlir::failure();
  return ::mlir::success();
}

void LoadNdOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);

  writer.writeOptionalAttribute(prop.packed);

  writer.writeOptionalAttribute(prop.transpose);
}

::std::optional<bool> LoadNdOp::getPacked() {
  auto attr = getPackedAttr();
  return attr ? ::std::optional<bool>(attr != nullptr) : (::std::nullopt);
}

::std::optional<::llvm::ArrayRef<int64_t>> LoadNdOp::getTranspose() {
  auto attr = getTransposeAttr();
  return attr ? ::std::optional<::llvm::ArrayRef<int64_t>>(attr) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> LoadNdOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void LoadNdOp::setPacked(bool attrValue) {
    auto &odsProp = getProperties().packed;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void LoadNdOp::setTranspose(::std::optional<::llvm::ArrayRef<int64_t>> attrValue) {
    auto &odsProp = getProperties().transpose;
    if (attrValue)
      odsProp = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(*attrValue);
    else
      odsProp = nullptr;
}

void LoadNdOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadNdOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadNdOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void LoadNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type value, ::mlir::Value TensorDesc, /*optional*/::mlir::UnitAttr packed, /*optional*/::mlir::DenseI64ArrayAttr transpose, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (packed) {
    odsState.getOrAddProperties<Properties>().packed = packed;
  }
  if (transpose) {
    odsState.getOrAddProperties<Properties>().transpose = transpose;
  }
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  odsState.addTypes(value);
}

void LoadNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, /*optional*/::mlir::UnitAttr packed, /*optional*/::mlir::DenseI64ArrayAttr transpose, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (packed) {
    odsState.getOrAddProperties<Properties>().packed = packed;
  }
  if (transpose) {
    odsState.getOrAddProperties<Properties>().transpose = transpose;
  }
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void LoadNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<LoadNdOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void LoadNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult LoadNdOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;
  auto tblgen_packed = getProperties().packed; (void)tblgen_packed;
  auto tblgen_transpose = getProperties().transpose; (void)tblgen_transpose;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU8(*this, tblgen_packed, "packed")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(*this, tblgen_transpose, "transpose")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSResults(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSResults(0).begin()))))))
    return emitOpError("failed to verify that all of {value, TensorDesc} have same element type");
  return ::mlir::success();
}

::llvm::LogicalResult LoadNdOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult LoadNdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);
  ::mlir::Type valueRawType{};
  ::llvm::ArrayRef<::mlir::Type> valueTypes(&valueRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawType = type;
  }
  result.addTypes(valueTypes);
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult LoadNdOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.packed;
    auto packedAttrName = StringAttr::get(ctx, "packed");
    auto attr = dict.get(packedAttrName);
    usedKeys.insert(packedAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for packed in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `packed` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.transpose;
    auto transposeAttrName = StringAttr::get(ctx, "transpose");
    auto attr = dict.get(transposeAttrName);
    usedKeys.insert(transposeAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for transpose in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `transpose` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void LoadNdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void LoadNdOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::LoadNdOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::NbarrierArriveOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
NbarrierArriveOpGenericAdaptorBase::NbarrierArriveOpGenericAdaptorBase(NbarrierArriveOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
NbarrierArriveOpAdaptor::NbarrierArriveOpAdaptor(NbarrierArriveOp op) : NbarrierArriveOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult NbarrierArriveOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult NbarrierArriveOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute NbarrierArriveOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code NbarrierArriveOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> NbarrierArriveOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void NbarrierArriveOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void NbarrierArriveOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult NbarrierArriveOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void NbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value nbarrier) {
  odsState.addOperands(nbarrier);
}

void NbarrierArriveOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value nbarrier) {
  odsState.addOperands(nbarrier);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NbarrierArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void NbarrierArriveOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult NbarrierArriveOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult NbarrierArriveOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult NbarrierArriveOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand nbarrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> nbarrierOperands(&nbarrierRawOperand, 1);  ::llvm::SMLoc nbarrierOperandsLoc;
  (void)nbarrierOperandsLoc;
  ::mlir::Type nbarrierRawType{};
  ::llvm::ArrayRef<::mlir::Type> nbarrierTypes(&nbarrierRawType, 1);

  nbarrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(nbarrierRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(nbarrierRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(nbarrierOperands, nbarrierTypes, nbarrierOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void NbarrierArriveOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getNbarrier();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getNbarrier().getType();
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::NbarrierArriveOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::NbarrierWaitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
NbarrierWaitOpGenericAdaptorBase::NbarrierWaitOpGenericAdaptorBase(NbarrierWaitOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
NbarrierWaitOpAdaptor::NbarrierWaitOpAdaptor(NbarrierWaitOp op) : NbarrierWaitOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult NbarrierWaitOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult NbarrierWaitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute NbarrierWaitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code NbarrierWaitOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> NbarrierWaitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void NbarrierWaitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void NbarrierWaitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult NbarrierWaitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void NbarrierWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value nbarrier) {
  odsState.addOperands(nbarrier);
}

void NbarrierWaitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value nbarrier) {
  odsState.addOperands(nbarrier);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NbarrierWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void NbarrierWaitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult NbarrierWaitOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU11(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult NbarrierWaitOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult NbarrierWaitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand nbarrierRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> nbarrierOperands(&nbarrierRawOperand, 1);  ::llvm::SMLoc nbarrierOperandsLoc;
  (void)nbarrierOperandsLoc;
  ::mlir::Type nbarrierRawType{};
  ::llvm::ArrayRef<::mlir::Type> nbarrierTypes(&nbarrierRawType, 1);

  nbarrierOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(nbarrierRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(nbarrierRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(nbarrierOperands, nbarrierTypes, nbarrierOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void NbarrierWaitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getNbarrier();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getNbarrier().getType();
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::NbarrierWaitOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::PrefetchNdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrefetchNdOpGenericAdaptorBase::PrefetchNdOpGenericAdaptorBase(PrefetchNdOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
PrefetchNdOpAdaptor::PrefetchNdOpAdaptor(PrefetchNdOp op) : PrefetchNdOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult PrefetchNdOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.prefetch_nd' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.prefetch_nd' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.prefetch_nd' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchNdOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PrefetchNdOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PrefetchNdOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PrefetchNdOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;
  return std::nullopt;
}

void PrefetchNdOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }
}

void PrefetchNdOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);
}

::llvm::LogicalResult PrefetchNdOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult PrefetchNdOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PrefetchNdOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchNdOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void PrefetchNdOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchNdOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchNdOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
}

void PrefetchNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrefetchNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<PrefetchNdOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void PrefetchNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult PrefetchNdOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchNdOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult PrefetchNdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchNdOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void PrefetchNdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::PrefetchNdOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::PrefetchOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrefetchOpGenericAdaptorBase::PrefetchOpGenericAdaptorBase(PrefetchOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
PrefetchOpAdaptor::PrefetchOpAdaptor(PrefetchOp op) : PrefetchOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult PrefetchOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.prefetch' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.prefetch' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.prefetch' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PrefetchOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PrefetchOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PrefetchOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;
  return std::nullopt;
}

void PrefetchOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }
}

void PrefetchOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);
}

::llvm::LogicalResult PrefetchOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PrefetchOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> PrefetchOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void PrefetchOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void PrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
}

void PrefetchOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<PrefetchOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void PrefetchOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult PrefetchOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult PrefetchOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult PrefetchOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void PrefetchOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::PrefetchOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::StoreNdOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StoreNdOpGenericAdaptorBase::StoreNdOpGenericAdaptorBase(StoreNdOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
StoreNdOpAdaptor::StoreNdOpAdaptor(StoreNdOp op) : StoreNdOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult StoreNdOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.store_nd' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.store_nd' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.store_nd' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult StoreNdOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute StoreNdOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code StoreNdOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> StoreNdOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;
  return std::nullopt;
}

void StoreNdOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }
}

void StoreNdOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);
}

::llvm::LogicalResult StoreNdOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult StoreNdOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();
  return ::mlir::success();
}

void StoreNdOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreNdOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void StoreNdOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreNdOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreNdOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(value);
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
}

void StoreNdOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value TensorDesc, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(value);
  odsState.addOperands(TensorDesc);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StoreNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<StoreNdOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void StoreNdOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult StoreNdOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))))))
    return emitOpError("failed to verify that all of {value, TensorDesc} have same element type");
  return ::mlir::success();
}

::llvm::LogicalResult StoreNdOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StoreNdOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(&valueRawOperand, 1);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::Type valueRawType{};
  ::llvm::ArrayRef<::mlir::Type> valueTypes(&valueRawType, 1);
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult StoreNdOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void StoreNdOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getValue();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
}

void StoreNdOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::StoreNdOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::StoreScatterOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
StoreScatterOpGenericAdaptorBase::StoreScatterOpGenericAdaptorBase(StoreScatterOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOpGenericAdaptorBase::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOpGenericAdaptorBase::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOpGenericAdaptorBase::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
StoreScatterOpAdaptor::StoreScatterOpAdaptor(StoreScatterOp op) : StoreScatterOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult StoreScatterOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (tblgen_l1_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l1_hint))))
    return emitError(loc, "'xegpu.store' op ""attribute 'l1_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l2_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l2_hint))))
    return emitError(loc, "'xegpu.store' op ""attribute 'l2_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");

  if (tblgen_l3_hint && !((::llvm::isa<::mlir::xegpu::CachePolicyAttr>(tblgen_l3_hint))))
    return emitError(loc, "'xegpu.store' op ""attribute 'l3_hint' failed to satisfy constraint: Describe the cache settings for prefetch/load/store operators");
  return ::mlir::success();
}

::llvm::LogicalResult StoreScatterOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.l1_hint;
       auto attr = dict.get("l1_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l2_hint;
       auto attr = dict.get("l2_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.l3_hint;
       auto attr = dict.get("l3_hint");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute StoreScatterOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.l1_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l1_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l2_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l2_hint",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.l3_hint;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("l3_hint",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code StoreScatterOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.l1_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l2_hint.getAsOpaquePointer()), 
    llvm::hash_value(prop.l3_hint.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> StoreScatterOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "l1_hint")
      return prop.l1_hint;

    if (name == "l2_hint")
      return prop.l2_hint;

    if (name == "l3_hint")
      return prop.l3_hint;
  return std::nullopt;
}

void StoreScatterOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "l1_hint") {
       prop.l1_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l1_hint)>>(value);
       return;
    }

    if (name == "l2_hint") {
       prop.l2_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l2_hint)>>(value);
       return;
    }

    if (name == "l3_hint") {
       prop.l3_hint = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.l3_hint)>>(value);
       return;
    }
}

void StoreScatterOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.l1_hint) attrs.append("l1_hint", prop.l1_hint);

    if (prop.l2_hint) attrs.append("l2_hint", prop.l2_hint);

    if (prop.l3_hint) attrs.append("l3_hint", prop.l3_hint);
}

::llvm::LogicalResult StoreScatterOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getL1HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l1_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL2HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l2_hint", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getL3HintAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(attr, "l3_hint", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult StoreScatterOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.l1_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l2_hint)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.l3_hint)))
    return ::mlir::failure();
  return ::mlir::success();
}

void StoreScatterOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.l1_hint);

  writer.writeOptionalAttribute(prop.l2_hint);

  writer.writeOptionalAttribute(prop.l3_hint);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOp::getL1Hint() {
  auto attr = getL1HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOp::getL2Hint() {
  auto attr = getL2HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

::std::optional<::mlir::xegpu::CachePolicy> StoreScatterOp::getL3Hint() {
  auto attr = getL3HintAttr();
  return attr ? ::std::optional<::mlir::xegpu::CachePolicy>(attr.getValue()) : (::std::nullopt);
}

void StoreScatterOp::setL1Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l1_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreScatterOp::setL2Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l2_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreScatterOp::setL3Hint(::std::optional<::mlir::xegpu::CachePolicy> attrValue) {
    auto &odsProp = getProperties().l3_hint;
    if (attrValue)
      odsProp = ::mlir::xegpu::CachePolicyAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue);
    else
      odsProp = nullptr;
}

void StoreScatterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value value, ::mlir::Value TensorDesc, ::mlir::Value mask, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(value);
  odsState.addOperands(TensorDesc);
  odsState.addOperands(mask);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
}

void StoreScatterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value value, ::mlir::Value TensorDesc, ::mlir::Value mask, /*optional*/::mlir::xegpu::CachePolicyAttr l1_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l2_hint, /*optional*/::mlir::xegpu::CachePolicyAttr l3_hint) {
  odsState.addOperands(value);
  odsState.addOperands(TensorDesc);
  odsState.addOperands(mask);
  if (l1_hint) {
    odsState.getOrAddProperties<Properties>().l1_hint = l1_hint;
  }
  if (l2_hint) {
    odsState.getOrAddProperties<Properties>().l2_hint = l2_hint;
  }
  if (l3_hint) {
    odsState.getOrAddProperties<Properties>().l3_hint = l3_hint;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void StoreScatterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<StoreScatterOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void StoreScatterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 3u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult StoreScatterOp::verifyInvariantsImpl() {
  auto tblgen_l1_hint = getProperties().l1_hint; (void)tblgen_l1_hint;
  auto tblgen_l2_hint = getProperties().l2_hint; (void)tblgen_l2_hint;
  auto tblgen_l3_hint = getProperties().l3_hint; (void)tblgen_l3_hint;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l1_hint, "l1_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l2_hint, "l2_hint")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU7(*this, tblgen_l3_hint, "l3_hint")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  if (!(((getElementTypeOrSelf((*this->getODSOperands(0).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) && (getElementTypeOrSelf((*this->getODSOperands(1).begin()))) == (getElementTypeOrSelf((*this->getODSOperands(0).begin()))))))
    return emitOpError("failed to verify that all of {value, TensorDesc} have same element type");
  return ::mlir::success();
}

::llvm::LogicalResult StoreScatterOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult StoreScatterOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand valueRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> valueOperands(&valueRawOperand, 1);  ::llvm::SMLoc valueOperandsLoc;
  (void)valueOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand maskRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> maskOperands(&maskRawOperand, 1);  ::llvm::SMLoc maskOperandsLoc;
  (void)maskOperandsLoc;
  ::mlir::Type valueRawType{};
  ::llvm::ArrayRef<::mlir::Type> valueTypes(&valueRawType, 1);
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);
  ::mlir::Type maskRawType{};
  ::llvm::ArrayRef<::mlir::Type> maskTypes(&maskRawType, 1);

  valueOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(valueRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  maskOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(maskRawOperand))
    return ::mlir::failure();
  if (parseProperties(parser, result))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    valueRawType = type;
  }
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    maskRawType = type;
  }
  if (parser.resolveOperands(valueOperands, valueTypes, valueOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(maskOperands, maskTypes, maskOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

::llvm::LogicalResult StoreScatterOp::setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
  // keep track of used keys in the input dictionary to be able to error out
  // if there are some unknown ones.
  DenseSet<StringAttr> usedKeys;
  MLIRContext *ctx = dict.getContext();
  (void)ctx;
  {

    auto &propStorage = prop.l1_hint;
    auto l1_hintAttrName = StringAttr::get(ctx, "l1_hint");
    auto attr = dict.get(l1_hintAttrName);
    usedKeys.insert(l1_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l1_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l1_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l2_hint;
    auto l2_hintAttrName = StringAttr::get(ctx, "l2_hint");
    auto attr = dict.get(l2_hintAttrName);
    usedKeys.insert(l2_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l2_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l2_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  {

    auto &propStorage = prop.l3_hint;
    auto l3_hintAttrName = StringAttr::get(ctx, "l3_hint");
    auto attr = dict.get(l3_hintAttrName);
    usedKeys.insert(l3_hintAttrName);
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        emitError() << "expected key entry for l3_hint in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `l3_hint` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  for (NamedAttribute attr : dict) {
    if (!usedKeys.contains(attr.getName()))
      return emitError() << "unknown key '" << attr.getName() <<
          "' when parsing properties dictionary";
  }
  return ::mlir::success();
}

void StoreScatterOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getValue();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getMask();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedProps;
  _odsPrinter << " ";
  printProperties(this->getContext(), _odsPrinter, getProperties(), elidedProps);
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict(llvm::to_vector((*this)->getDiscardableAttrs()), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getValue().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getMask().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void StoreScatterOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::StoreScatterOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::UpdateNdOffsetOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
UpdateNdOffsetOpGenericAdaptorBase::UpdateNdOffsetOpGenericAdaptorBase(UpdateNdOffsetOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

std::pair<unsigned, unsigned> UpdateNdOffsetOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::llvm::ArrayRef<int64_t> UpdateNdOffsetOpGenericAdaptorBase::getConstOffsets() {
  auto attr = getConstOffsetsAttr();
  return attr;
}

} // namespace detail
UpdateNdOffsetOpAdaptor::UpdateNdOffsetOpAdaptor(UpdateNdOffsetOp op) : UpdateNdOffsetOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult UpdateNdOffsetOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_const_offsets = getProperties().const_offsets; (void)tblgen_const_offsets;
  if (!tblgen_const_offsets) return emitError(loc, "'xegpu.update_nd_offset' op ""requires attribute 'const_offsets'");

  if (tblgen_const_offsets && !((::llvm::isa<::mlir::DenseI64ArrayAttr>(tblgen_const_offsets))))
    return emitError(loc, "'xegpu.update_nd_offset' op ""attribute 'const_offsets' failed to satisfy constraint: i64 dense array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> UpdateNdOffsetOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {false, true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 1) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::MutableOperandRange UpdateNdOffsetOp::getOffsetsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

::llvm::LogicalResult UpdateNdOffsetOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.const_offsets;
       auto attr = dict.get("const_offsets");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `const_offsets` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute UpdateNdOffsetOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.const_offsets;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("const_offsets",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code UpdateNdOffsetOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.const_offsets.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> UpdateNdOffsetOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "const_offsets")
      return prop.const_offsets;
  return std::nullopt;
}

void UpdateNdOffsetOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "const_offsets") {
       prop.const_offsets = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.const_offsets)>>(value);
       return;
    }
}

void UpdateNdOffsetOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.const_offsets) attrs.append("const_offsets", prop.const_offsets);
}

::llvm::LogicalResult UpdateNdOffsetOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getConstOffsetsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(attr, "const_offsets", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult UpdateNdOffsetOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.const_offsets)))
    return ::mlir::failure();
  return ::mlir::success();
}

void UpdateNdOffsetOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.const_offsets);
}

::llvm::ArrayRef<int64_t> UpdateNdOffsetOp::getConstOffsets() {
  auto attr = getConstOffsetsAttr();
  return attr;
}

void UpdateNdOffsetOp::setConstOffsets(::llvm::ArrayRef<int64_t> attrValue) {
  getProperties().const_offsets = ::mlir::Builder((*this)->getContext()).getDenseI64ArrayAttr(attrValue);
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value TensorDesc, ::mlir::ValueRange offsets, ::mlir::DenseI64ArrayAttr const_offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  odsState.getOrAddProperties<Properties>().const_offsets = const_offsets;
  odsState.addTypes(result);
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, ::mlir::ValueRange offsets, ::mlir::DenseI64ArrayAttr const_offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  odsState.getOrAddProperties<Properties>().const_offsets = const_offsets;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value TensorDesc, ::mlir::ValueRange offsets, ::llvm::ArrayRef<int64_t> const_offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  odsState.getOrAddProperties<Properties>().const_offsets = odsBuilder.getDenseI64ArrayAttr(const_offsets);
  odsState.addTypes(result);
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, ::mlir::ValueRange offsets, ::llvm::ArrayRef<int64_t> const_offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  odsState.getOrAddProperties<Properties>().const_offsets = odsBuilder.getDenseI64ArrayAttr(const_offsets);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<UpdateNdOffsetOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

void UpdateNdOffsetOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult UpdateNdOffsetOp::verifyInvariantsImpl() {
  auto tblgen_const_offsets = getProperties().const_offsets; (void)tblgen_const_offsets;
  if (!tblgen_const_offsets) return emitOpError("requires attribute 'const_offsets'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_XeGPU4(*this, tblgen_const_offsets, "const_offsets")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU7(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()) && ((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {TensorDesc, result} have same type");
  return ::mlir::success();
}

::llvm::LogicalResult UpdateNdOffsetOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult UpdateNdOffsetOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> offsetsOperands;
  ::llvm::SMLoc offsetsOperandsLoc;
  (void)offsetsOperandsLoc;
  ::mlir::DenseI64ArrayAttr const_offsetsAttr;
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();
  {
    offsetsOperandsLoc = parser.getCurrentLocation();
    auto odsResult = parseDynamicIndexList(parser, offsetsOperands, const_offsetsAttr);
    if (odsResult) return ::mlir::failure();
    result.getOrAddProperties<UpdateNdOffsetOp::Properties>().const_offsets = const_offsetsAttr;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIndexType();
  result.addTypes(resultTypes);
  if (parser.resolveOperands(TensorDescOperands, resultTypes[0], TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(offsetsOperands, odsBuildableType0, offsetsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void UpdateNdOffsetOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  printDynamicIndexList(_odsPrinter, *this, getOffsets(), getConstOffsetsAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("const_offsets");
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

void UpdateNdOffsetOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::UpdateNdOffsetOp)

namespace mlir {
namespace xegpu {

//===----------------------------------------------------------------------===//
// ::mlir::xegpu::UpdateOffsetOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
UpdateOffsetOpGenericAdaptorBase::UpdateOffsetOpGenericAdaptorBase(UpdateOffsetOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
UpdateOffsetOpAdaptor::UpdateOffsetOpAdaptor(UpdateOffsetOp op) : UpdateOffsetOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult UpdateOffsetOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult UpdateOffsetOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute UpdateOffsetOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code UpdateOffsetOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> UpdateOffsetOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void UpdateOffsetOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void UpdateOffsetOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult UpdateOffsetOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void UpdateOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value TensorDesc, ::mlir::Value offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  odsState.addTypes(result);
}

void UpdateOffsetOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value TensorDesc, ::mlir::Value offsets) {
  odsState.addOperands(TensorDesc);
  odsState.addOperands(offsets);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void UpdateOffsetOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void UpdateOffsetOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::llvm::LogicalResult UpdateOffsetOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU6(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_XeGPU1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  if (!((((*this->getODSOperands(0).begin()).getType()) == ((*this->getODSResults(0).begin()).getType()) && ((*this->getODSResults(0).begin()).getType()) == ((*this->getODSOperands(0).begin()).getType()))))
    return emitOpError("failed to verify that all of {TensorDesc, result} have same type");
  return ::mlir::success();
}

::llvm::LogicalResult UpdateOffsetOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult UpdateOffsetOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand TensorDescRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> TensorDescOperands(&TensorDescRawOperand, 1);  ::llvm::SMLoc TensorDescOperandsLoc;
  (void)TensorDescOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand offsetsRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> offsetsOperands(&offsetsRawOperand, 1);  ::llvm::SMLoc offsetsOperandsLoc;
  (void)offsetsOperandsLoc;
  ::mlir::Type TensorDescRawType{};
  ::llvm::ArrayRef<::mlir::Type> TensorDescTypes(&TensorDescRawType, 1);
  ::mlir::Type offsetsRawType{};
  ::llvm::ArrayRef<::mlir::Type> offsetsTypes(&offsetsRawType, 1);

  TensorDescOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(TensorDescRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  offsetsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(offsetsRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(TensorDescRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::VectorType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    offsetsRawType = type;
  }
  result.addTypes(TensorDescTypes[0]);
  if (parser.resolveOperands(TensorDescOperands, TensorDescTypes, TensorDescOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(offsetsOperands, offsetsTypes, offsetsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void UpdateOffsetOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getTensorDesc();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getOffsets();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getTensorDesc().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getOffsets().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::VectorType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

} // namespace xegpu
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::xegpu::UpdateOffsetOp)


#endif  // GET_OP_CLASSES

